/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: msgbox.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Defines the standard routines for popping up simple
*				message boxes. The text in message boxes is always
*				displayed in the standard system font, in the standard
*				static text color.
*
* $Id: msgbox.hpp 1.2 1994/03/09 11:50:10 kjb Exp $
*
****************************************************************************/

#ifndef	__MSGBOX_HPP
#define	__MSGBOX_HPP

#ifndef	__MVISION_HPP
#include "mvision.hpp"
#endif

/*------------------------------ Constants --------------------------------*/

const ushort

// Standard message box classes

	mfWarning		= 0x0000,			// Display a warning box
	mfError			= 0x0001,			// Display an error box
	mfInformation	= 0x0002,			// Display an information box
	mfConfirmation	= 0x0003,			// Display a confirmation box

// Text control flags

	mfCenterText	= 0x0004,			// Center the text in the box

// Message box button flags

	mfYesButton		= 0x0010,			// Box has a Yes button
	mfNoButton		= 0x0020,			// Box has a No button
	mfOKButton		= 0x0040,			// Box has an OK button
	mfCancelButton	= 0x0080,			// Box has a Cancel button

	mfYesDefault	= 0x0100,			// Yes button is the default
	mfNoDefault		= 0x0200,			// No button is the default
	mfOKDefault		= 0x0400,			// OK button is the default
	mfCancelDefault	= 0x0800,			// Cancel button is the default

	mfYesNoCancel	= mfYesButton | mfNoButton | mfCancelButton,
	mfOKCancel		= mfOKButton | mfCancelButton;

/*-------------------------- Class Definitions ----------------------------*/

struct MsgBoxText {
	static const char *yesText;
	static const char *noText;
	static const char *okText;
	static const char *cancelText;
	static const char *warningText;
	static const char *errorText;
	static const char *informationText;
	static const char *confirmText;
	};

/*------------------------- Function Prototypes ---------------------------*/

ushort messageBox(const char *msg,ushort options);
ushort messageBox(ushort options,const char *msg, ... );
ushort inputBox(const char *title,const char *label,char *s,short limit);

#endif	// __MSGBOX_HPP
