/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: misc.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Implementation for the miscellaneous functions used by
*				the library.
*
* $Id: misc.cpp 1.2 1994/03/09 11:50:25 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "techlib.hpp"
#include "tprogram.hpp"
#include <string.h>
#include <ctype.h>
#include <dos.h>

/*---------------------------- Global Variables ---------------------------*/

// Different mouse cursors

cursor CHECK_CURSOR = {
	0xFFF0, 0xFFE0, 0xFFC0, 0xFF81,
	0xFF03, 0x0607, 0x000F, 0x001F,
	0x803F, 0xC07F, 0xE0FF, 0xF1FF,
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,

	0x0000, 0x0006, 0x000C, 0x0018,
	0x0030, 0x0060, 0x70C0, 0x3980,
	0x1F00, 0x0E00, 0x0400, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000,
	0x0005, 0x000A };

cursor CROSS_CURSOR = {
	0xF01F, 0xE00F, 0xC007, 0x8003,
	0x0441, 0x0C61, 0x0381, 0x0381,
	0x0381, 0x0C61, 0x0441, 0x8003,
	0xC007, 0xE00F, 0xF01F, 0xFFFF,

	0x0000, 0x07C0, 0x0920, 0x1110,
	0x2108, 0x4004, 0x4004, 0x783C,
	0x4004, 0x4004, 0x2108, 0x1110,
	0x0920, 0x07C0, 0x0000, 0x0000,
	0x0007, 0x0007 };

cursor GLOVE_CURSOR = {
	0xF3FF, 0xE1FF, 0xE1FF, 0xE1FF,
	0xE1FF, 0xE049, 0xE000, 0x8000,
	0x0000, 0x0000, 0x07FC, 0x07F8,
	0x9FF9, 0x8FF1, 0xC003, 0xE007,

	0x0C00, 0x1200, 0x1200, 0x1200,
	0x1200, 0x13B6, 0x1249, 0x7249,
	0x9249, 0x9001, 0x9001, 0x8001,
	0x4002, 0x4002, 0x2004, 0x1FF8,
	0x0004, 0x0000 };

cursor IBEAM_CURSOR = {
	0xF39F, 0xFD7F, 0xFEFF, 0xFEFF,
	0xFEFF, 0xFEFF, 0xFEFF, 0xFEFF,
	0xFEFF, 0xFEFF, 0xFEFF, 0xFEFF,
	0xFEFF, 0xFEFF, 0xFD7F, 0xF39F,

	0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000,
	0x0007, 0x0008 };

cursor *_MVIS_currentCursor = &DEF_CURSOR;

/*----------------------------- Implementation ----------------------------*/

char *newStr(const char *str)
/****************************************************************************
*
* Function:		newStr
* Parameters:	str	- Pointer to string to copy
* Returns:		Pointer to the copied string on the heap
*
****************************************************************************/
{
	if (str) {
		char *temp = new char[strlen(str)+1];
		strcpy(temp,str);
		return temp;
		}
	else
		return NULL;
}

char *newHotStr(const char *str,char& hotChar,ushort& hotIndex)
/****************************************************************************
*
* Function:		newHotStr
* Parameters:	str			- String to parse for hot character value
*				hotChar		- Place to store the hotCharacter
*				hotIndex	- Index of the hotCharacter in returned string
* Returns:		Pointer to copy of string with hot character stripped
*
* Description:  Finds the hot character value in a string and extracts
*				it if present, returning a copy of the string without the
*				hot character.
*
****************************************************************************/
{
	if (str == NULL) {
		hotChar = 0;
		return NULL;
		}

	char	*p = strchr(str,'~');

	if (p == NULL) {
		hotChar = 0;
		hotIndex = 0;
		return newStr(str);
		}
	else {
		PRECONDITION(strchr(p+1,'~') == p+2 && strchr(p+3,'~') == NULL);
		char *temp = new char[strlen(str)-1];
		hotChar = p[1];
		p = temp;
		while (*str != '~')
			*p++ = *str++;
		hotIndex = p - temp;
		*p++ = hotChar;
		str += 3;
		while (*str != '\0')
			*p++ = *str++;
		*p = 0;
		hotChar = tolower(hotChar);
		return temp;
		}
}

int countLines(const char *msg,int maxWidth,bool wrap)
/****************************************************************************
*
* Function:		countLines
* Parameters:	msg			- Message string to count
*				maxWidth	- Maximum width of the string
*				wrap		- True if text should wrap at maximum width
* Returns:		Number of lines in the text string.
*
* Description:	Counts the number of lines in a text string, drawn in the
*				currently active font and wrapping at the specified
*				maximum width (if wrapping is true).
*
****************************************************************************/
{
	const char	*p = msg;
	int			width = 0;
	int 		lines = 1;

	while (*p) {
		if (*p == '\n' || *p == '\\' && *(p+1) == 'n') {
			width = 0;
			lines++;
			if (*p == '\\')
				p++;
			}
		else if (wrap && (width += MGL_charWidth(*p)) > maxWidth) {
			while (*p != ' ')
				p--;				// Back up to previous space character

			width = 0;
			lines++;
			}
		p++;
		}
	return lines;
}

void beep(void)
/****************************************************************************
*
* Function:		beep
*
* Description:	Beeps the speaker.
*
****************************************************************************/
{
	sound(1500);
	delay(50);
	nosound();
}
