#include <stdio.h>
#include <stdlib.h>

void main(int argn, char *argv[]) {

	FILE *bitmap, *palette;
	char bits, red, green, blue;
	int count;

	if(argn<2) {
		printf("Usage: bmp2pal bitmap [palette]\n");
		exit(1);
	}

	bitmap = fopen(argv[1], "r");
	if(bitmap == NULL) {
		printf("Can't find %s!\n", argv[1]);
		exit(1);
	}

	if(argn==3) {
		palette = fopen(argv[2], "w+b");
		if(palette==NULL) {
			printf("Can't write to %s!\n", argv[2]);
			exit(1);
		}
	}
	else {
		palette = fopen("temp.pal", "w+b");
		if(palette==NULL) {
			printf("Can't write to temp.pal!\n");
			exit(1);
		}
	}

	if (fgetc(bitmap) != 'B' || fgetc(bitmap) != 'M') {
		printf("Not a bitmap!\n");
		exit(1);
	}

	fseek(bitmap, 28, 0);
	bits = fgetc(bitmap);

	if (bits != 8 && bits != 24) {
		printf("8 and 24 bit files only please!\n");
		exit(1);
	}

	if (bits == 24) {
		printf("24 bit images don't have a palette.\n");
		printf("I'll just grab the first 256 pixels.\n");
	}

	fseek(bitmap, 54, 0);

	for (count=0; count < 256; count++) {
		blue = fgetc(bitmap);
		green = fgetc(bitmap);
		red = fgetc(bitmap);
		fputc(red, palette);
		fputc(green, palette);
		fputc(blue, palette);
		if (bits == 8) fgetc(bitmap);
	}

	fclose(bitmap);
	fclose(palette);

}