/*
 * grafex2.c
 *
 * the same example program, done with halo calls
 *
 * compile with:
 *  MSC - msc grafex2;
 *        link grafex2,,,grafix
 *
 *  TC  - tcc grafex2 <grafix lib directory>\grafix.lib
 */

#include <stdio.h>
#include <conio.h>
#include <math.h>
#include "graf.h"
#include "halo.h"

#define pi 3.1415926
#define MAXVERT 100

main()
{
  int n, i, j, d;
  float x1, y1, x2, y2;
  int c;
  struct g_info inf;
  struct {
    float x, y;
  } vert[MAXVERT];

  printf("n: ");
  scanf("%d", &n);
  if (n < 2 || n > MAXVERT) {
    printf("Oop Ack!\n");
    exit(1);
  }

  g_init(0);
  g_open(CGA_320);	/* use 4-color mode on CGA. on an EGA, the mode   */
			/* parameter is ignored and 16-color mode is used */
  g_info(&inf);
  halo_init();

  x1 = -3;		/* lower left corner */
  y1 = -3;
  x2 = 3;		/* upper right corner */
  y2 = 3;
  setworld(&x1, &y1, &x2, &y2);

/* space n vertices equally on an ellipse that fits nicely on the screen */

  for (i=0; i<n; i++) {
    vert[i].x = 2.0*sin(2*pi/n*i);
    vert[i].y = 2.0*cos(2*pi/n*i);
  }

/*
 * draw the figure. the colors are selected so that points that are the
 * same distance from each other on the ellipse have the same color.
 */

  for (i=0; i<n; i++)
    for (j=i+1; j<n; j++) {
      d = j-i;
      if (d > n/2) d = n - d;
      c = (float)d/(n/2+1)*inf.colormax + 1;
      setcolor(&c);
      movabs(&vert[i].x, &vert[i].y);
      lnabs(&vert[j].x, &vert[j].y);
    }

/* wait... */

  g_writestr(0, 0, "Press any key...", 1, -1);
  getch();

/* and clean up. */

  g_close();
}
