// height field test file for use with POV-Ray 2.2
// and gforge v1.1f            jpb 8/15/95

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
// #include "stones.inc"

// y is up, x to the right, z into the screen

camera {
	location        <.2, -1.0, -1.5>
	direction       <0, 0, 2.5>
	up              <0, 0, -1>
	right           <4/3, 0, 0>
	look_at         <.5, .5, -.1>
}

/* yellowish light */
object { light_source { <3, 2, -1>  color red 1 green .75 blue .5
  area_light <0.2, 0, 0> <0,0,-2.5> 2, 7
  adaptive 1
  jitter
  } 
}

/* reddish light */
object { light_source { <-3, -3, -.7> color red .7 green .28 blue .112
    area_light <.5, -.5, 0> <0, 0, -1> 2, 10
    adaptive 1
    jitter
   }
}


/* sky background fill light */
object { light_source { <-2, -2, -10>  color red .03 green .084 blue .12
  area_light <4, 0, 0> <0, 4, 0> 3, 3
  adaptive 1
  jitter
  } 
}

/* light up the sky itself */
light_source { <1,-1,1> color White
		spotlight
		point_at <1,1,-10>
		radius 100 falloff 180
	}

// big light in the sky 

object { sphere { <30,20,-10> 2 }
	 texture { pigment { White }
		   finish { ambient 2 } 
		 }
	} 

object {
	sphere  { <0, 0, 100>, 100               /* sky sphere */
		  texture { 
			    pigment { gradient z
			    color_map { 
			       [ 0.0 color red 0 green 0 blue .6 ]
			       [ 0.4 color red .05 green .05 blue .55 ]
			       [ 0.5 color red .1 green .1 blue .5 ]
			       [ 0.7 color red .1 green .1 blue .35 ]
			       [ 1.0 color Black ]

				       } /* end color_map */
			    } /* end pigment */
			   scale <200, 200, 200>
			  }  /* end texture */
		} /* end sphere */
	translate <0, 0, -100>
	} /* end object */


object {
	 height_field {tga "output.tga" }
	 scale < 1, 0.2, 1 >              // reduce height (was ys=0.20)
	 rotate < -90, 0, 0 >              // flip up from xz plane to xy plane
	 translate < 0, 0, 0 >
	 texture { 
		      pigment {color White}
		      finish { diffuse 1 ambient 0.02 }
		    }
       } /* end object */

/*
/* mirror sphere for test purposes */
 object {
  sphere { <.5,.5,-.3> 0.2
	texture { pigment {color Black}
		  finish {reflection 1.0}
		}
	 }
	}
*/
