/* DISPPIX by Jonathan Joshua    06-04-1989

    This program will display a Degas .PI{1,2,3} file on
    a properly equipped IBM-PC.

    Written in MS QuickC 2.0.

    Thanks to mmcabe@mtus5 and dal@syntel.

*/


/* WARNING: Compile without DEBUG option.  Strange results if
        compiled with DEBUG.  I don't know why!
*/



#include <stdio.h>
#include <stdlib.h>
#include <graph.h>


main(int argc, char **argv)
{
    unsigned int mode, i, i2, c, x = 0, y = 0;
    unsigned int t1, t2, t3, t4;
    unsigned int word1, word2, word3, word4;
    unsigned long colormap[16];
    unsigned int mask[16];
    FILE *pixfil;
    short resinf[3] = {_MRES16COLOR, _HRES16COLOR, _VRES2COLOR};

    if (argc < 2)      /* Need more input */
    {
             printf("Usage is: DISPPIX filename.PI{1,2,3}.\n");
             exit(-1);
    }

    if ((pixfil = fopen(argv[1], "rb")) == NULL)   /* File open? */
    {
             printf("File not found!\n");
             exit(-1);
    }

    fgetc(pixfil);                                  /* First byte is garbage */
    mode = fgetc(pixfil);                           /* Get the resolution */
    if (_setvideomode(resinf[mode]) == 0)           /* Enough res? */
    {
         printf("Sorry, resolution required not available.\n");
         exit(-1);
    }

    mask[0] = 32768;            /* We don't want to compute this stuff later */
    for(i=1;i<16;++i)
         mask[i] = (unsigned)(int) mask[i-1]/2;

    for(i=0;i<16;++i)          /* Read palette info and convert to EGA/VGA */
    {
         colormap[i] = (fgetc(pixfil)*0x09);
         colormap[i] += (((c=fgetc(pixfil)) & 0xf0)*0x90);
         colormap[i] += ((c & 0x0f)*0x90000);
    }

    _remapallpalette(colormap);      /* If you are colorblind leave this out */

    switch(mode)                     /* 3 cases instead of 1 nasty one */
    {
       case 2: for(i=0;i<16000;++i) /* 6440x400x2 */
               {
                  word1=(fgetc(pixfil)<<8)+fgetc(pixfil); /* What's the word */
                  for(i2=0;i2<16;++i2)
                    {
                       if ((word1 & mask[i2]) != 0)         /* Simple bitmap */
                           _setcolor(1);
                       else
                           _setcolor(0);
                       _setpixel(x,y+40);
                       x++;
                       if ((x %= 640) == 0)
                          y++;
                    }
               }
               break;
       case 1: for(i=0;i<8000;++i)  /* 640x200x4 */
               {
                  word1=(fgetc(pixfil)<<8)+fgetc(pixfil); /* Get 1 word */
                  word2=(fgetc(pixfil)<<8)+fgetc(pixfil); /* Do it again */
                  for(i2=0;i2<16;++i2)
                  {
                     t1 = (word1 & mask[i2])>>(15-i2);  /* Convert bitplanes */
                     t2 = (word2 & mask[i2])>>(15-i2);  /* to color value    */
                     _setcolor(t1 | (t2 << 1));
                     _setpixel(x,y);
                     ++x;
                     if ((x %= 640) == 0)
                        y++;
                  }
               }
               break;

       case 0: for(i=0;i<4000;++i)  /* 320x200x16 */
               {
                  word1=(fgetc(pixfil)<<8)+fgetc(pixfil);
                  word2=(fgetc(pixfil)<<8)+fgetc(pixfil);
                  word3=(fgetc(pixfil)<<8)+fgetc(pixfil);
                  word4=(fgetc(pixfil)<<8)+fgetc(pixfil);
                  for(i2=0;i2<16;++i2)
                  {
                     t1 = (word1 & mask[i2])>>(15-i2); /* 4 bitplanes for */
                     t2 = (word2 & mask[i2])>>(15-i2); /* this one        */
                     t3 = (word3 & mask[i2])>>(15-i2);
                     t4 = (word4 & mask[i2])>>(15-i2);
                     _setcolor(t1 | (t2 << 1) | (t3 << 2) | (t4 << 3));
                     _setpixel(x,y);
                     ++x;
                     if ((x %= 320) == 0)
                        y++;
                  }
               }
               break;

    }

    getchar();                    /* Hit return to end */

    _setvideomode(_DEFAULTMODE);  /* Be nice and reset things */
    fclose(pixfil);

    exit(0);      /* Outta' here on good behavior */
}