/*
        GEOS2.H

        by Marcus Grber 1993-94

        Include file for the PC/GEOS 2 file format
        Requires GEOS.H to be included first.
*/

#pragma pack(1)

/*
 *  Packed time and date structures; bitfield order is compiler dependant.
 */
typedef struct {
  unsigned short d:5;
  unsigned short m:4;
  unsigned short y:7;
} PackedFileDate;

typedef struct {
  unsigned short s_2:5;
  unsigned short m:6;
  unsigned short h:5;
} PackedFileTime;

/******************************************************************************
 *               GEOS standard file header (all file types)                   *
 ******************************************************************************/
#define GEOS2_ID 0x53C145C7             // GEOS2 file identification "magic"

typedef struct {                        /*** GEOS2 standard header */
  long ID;                              // GEOS2 id magic: C7 45 CF 53
  char name[GEOS_LONGNAME];             // long filename
  unsigned class;                       // geos filetype, see SDK docs
  unsigned flags;                       // attributes
  GEOSrelease release;                  // "release"
  GEOSprotocol protocol;                // protocol/version
  GEOStoken token;                      // file type/icon
  GEOStoken appl;                       // "token" of creator application
  char info[GEOS_INFO];                 // user file info
  char _copyright[24];                  // original files: Copyright notice
  char _x[8];
  PackedFileDate create_date;
  PackedFileTime create_time;           // creation date/time in DOS format
  char password[8];                     // password, encrypted as hex string
  char _x2[44];                         // not yet decoded
} GEOS2header;

typedef struct {                        /*** Additional VM file header */
  char _x1[8];
  unsigned IDVM;                        // VM id "magic"
  unsigned dirsize;                     // size of directory block (bytes)
  long dirptr;                          // absolute file pos of dir block
} GEOS2vmfheader;

#define GEOS2_DIRINFONAME "@DIRNAME.000"

#pragma pack()
