/************************************************************************/
/* Takes TABS out from an input file, replaces them with spaces,	*/
/* and writes the result to stdout. The usage is:			*/
/* detab (for stdin as input)						*/
/* or									*/
/* detab filename(s) (for input from given file(s))			*/
/* A filename of - denotes stdin					*/
/* Author: Georg K. Karawas, February 1989				*/
/************************************************************************/
#include <stdio.h>
#define LINSIZ 81
#define BUFRSIZ LINSIZ * 8

char *spaces = "        ";

main(argc, argv)
int argc;
char *argv[];
{
	extern	void exit();
	extern	FILE *fopen();
	extern	int fclose();
	FILE	*fp;
	int	i;
	int	status = 0;

	if (argc == 1) detab(stdin);
	else {
		for (i = 1;i < argc; i++) {
			status = 0;
			if (strcmp(argv[i], "-") == 0) fp = stdin;
			else {
				fp = fopen(argv[i], "r");
				if ( fp == (FILE * ) 0 ) {
					fprintf(stderr, "%s: cannot open %s\n", 
							argv[0], argv[i]);
					status = 1;
					continue;
				}
			}
			detab(fp);
			if (fp != stdin) fclose(fp);
		}
	}
	exit(status);
}

detab(fp)
FILE *fp;
{
	extern	char *strncpy();
	char	line[LINSIZ], buffer[BUFRSIZ];
	char	*pl, *pb;
	int	bufcnt, spccnt;

	while (fgets(line, LINSIZ, fp)) {
		pl = line;
		pb = buffer;
		bufcnt = 0;
		while (*pl) {
			if (*pl != '\t') {
				*pb++ = *pl++;
				bufcnt++;
			}
			else {
				spccnt = 8 * (1 + bufcnt / 8) - bufcnt;
				strncpy(pb, spaces, spccnt);
				bufcnt += spccnt;
				pb = buffer + bufcnt;
				pl++;
			}
		}
		*pb = 0;
		fprintf(stdout, "%s", buffer);
	}
}
