      program mklst

C* A small program to combine a fortran source file with 
C* error messages to create a list file similar to MS-Fortran 5.1 for
C* Fortran powerstation
C* This program also displays the error messages.

      implicit none

      integer*2 istat
      integer   in,irrf,out,del,i,j,ierrline,iforline,nargs
      logical   lstexist
      character forfile*64,irrfile*64,lstfile*64,ifmt(9)*4,
     &          errline*80,forline*80, buffer*80

      data in/10/,irrf/11/,out/12/,del/13/
      data ifmt/'(i1)','(i2)','(i3)','(i4)','(i5)','(i6)','(i7)',
     &          '(i8)','(i9)'/


C* Check number of arguments, should be 3, if not display help text
C* and quit

      if (nargs().lt.1+3) then
         write (*,*) 'MKLST ERROR: insufficient number of arguments'
         write (*,*)' '
         write (*,*) 'MKLST syntax:'
         write (*,*) '   mklst <fortran file> <error file> '//
     &               '<output list file>'
         write (*,*) 'where:'
         write (*,*) '   <fortran file>     = source file'
         write (*,*) '   <error file>       = file with error mess'//
     &               'ages of compiler'
         write (*,*) 'Create <error file> by adding eg. ">temp'//
     &         '.out" to the FL32 compilation command'

         write (*,*) '   <output list file> = list file as output '//
     &               'by mklst'
         stop ' '
      endif

C* Fetch arguments

      call getarg(1,forfile,istat)
      call getarg(2,irrfile,istat)
      call getarg(3,lstfile,istat)

C* OPEN FILES

C* Fortran input file

      open(in,file=forfile,status='OLD')

C* Error messages file

      open(irrf,file=irrfile,status='OLD')

C* File to be created, check if already existent, if so: DELETE

      inquire(file=lstfile,exist=lstexist)
      if (lstexist) then
         open(del,file=lstfile)
         close(del,status='DELETE')
      endif
      open(out,file=lstfile,status='NEW')

C* Initialize fornumber
      iforline = 0


C* Get first error message and its line number
      ierrline = 99999
  

 20   if (ierrline.ne.-1) then 
         errline = ' '
         read(irrf,'(a)',end=50) errline
         write(*,*) ' '//errline(1:max(1,len_trim(errline)))
         i = index(errline,'.FOR(')
         if (i.le.0) then
           goto 20
         endif
   
         j = index(errline,')')
         read(errline(i+5:j-1),ifmt(j-i-5)) ierrline  
      endif
      
C* Read fortran line

 30   read(in,'(a)',end=100) buffer
      forline = buffer(1:72)
      iforline = iforline + 1

      write(out,'(i6,a1,a)') iforline,' ',forline(1:
     &     max(1,len_trim(forline)))

C* Is there an error in this line?
 35   if (iforline.eq.ierrline) then

         write(out,'(a)') errline(1:max(1,len_trim(errline)))

C* Get next error message

 40      if (ierrline.ne.-1) then 
            errline = ' '
            read(irrf,'(a)',end=50) errline
            write(*,*) ' '//errline(1:max(1,len_trim(errline)))
            i = index(errline,'.FOR(')
            if (i.lt.0) goto 40
   
            j = index(errline,')')

            read(errline(i+5:j-1),ifmt(j-i-5)) ierrline  
         endif 
      endif

C* Check for more than one error in one line
      if (iforline.eq.ierrline) goto 35

C* Next fortran line

      goto 30

C* End of error messages file, set lijn to -1 as sign

 50   ierrline = -1
      goto 20

C* Normal end: close files

 100  close(in)
      close(irrf)
      close(out)

      stop ' '
      end