/*  Simerge.c designed to merge two comma delimited files of wsmr simtel    */
/*  ms-dos archives. Briefly, it opens two input files supplied as          */
/*  parameters to the program and creates a third, if supplied as a         */
/*  parameter, or it creates a temp file. Reads one line at a time from     */
/*  the two input files and compares them, character by character to        */
/*  find the lower character (excludes " and ,). If it comes across 8       */
/*  " or , the first files line will be written -eg if duplicate names.     */
/*                                                                          */
/*  If a third file name is not supplied, when the sort is complete, all    */
/*  files are closed, and then the first file is deleted and the temporary  */
/*  file renamed to the first.                                              */
/*                                                                          */
/*  Enjoy - Bryan Montgomery, Feb 4, 1994.                                  */
/*  The program can probably be compile into a smaller, faster one but I    */
/*  have a very limited compiler at the moment. I take no responsiblity     */
/*  for any effects of this program!                                        */
/*                                                                          */
/*  Enjoy - Bryan Montgomery, Feb 4, 1994.                                  */

#include "string.h"
#include "stdlib.h"
#include "stdio.h"

void Display_Help(void);
void Open_Files(char* szFile1, char* szFile2, char* szFile3);
int Read_File1(char *szLine_File1);
int Read_File2(char* szLine_File2);
void Write_Line (char* szData, char* File3);
void Remove_Temp_File (char* File1, char* File3);
int Compare_Lines (char* szLine1, char* szLine2, int bFile1, int bFile2);
void display (int *i);

FILE *fpFile1,
     *fpFile2,
     *fpFile3;

void main (int argc, char* argv[])
{
   char szOut_Name[120],
        szLine_File1[150],
        szLine_File2[150];
   int bFile1=0, bFile2=0,count=0;
   if (argc<3)
        Display_Help();
   if (argc==3)
        tmpnam (szOut_Name);
   else
        strcpy (szOut_Name,argv[3]);
   Open_Files(argv [1], argv[2], szOut_Name);
   Read_File1(szLine_File1);
   Read_File2(szLine_File2);
   printf ("\nWorking : ");
   while (!bFile1 || !bFile2) {
      display (&count);
      if (Compare_Lines (szLine_File1, szLine_File2, bFile1, bFile2)) {
         Write_Line (szLine_File1, szOut_Name);
         if (!bFile1)
            bFile1=Read_File1 (szLine_File1);
      } else {
         Write_Line (szLine_File2, szOut_Name);
         if (!bFile2)
            bFile2=Read_File2 (szLine_File2);
      }
   }
   fcloseall ();
   if (argc==3)
        Remove_Temp_File (argv[1], szOut_Name);
   printf("\b Done\nSorted ... output in file: %s\n",szOut_Name);
   exit(0);
}

void Display_Help (void) {
   printf ("\n  Merge will take 2 files, with lines up to 149 characters and sort\n");
   printf ("them alpabetically, up to the 8th \" or ,. If 2 parameters are supplied\n");
   printf ("the first file will be overwritten on completion. If 3 parameters are\n");
   printf ("supplied, the 3rd parameter will be the output file. Nb there must be\n");
   printf ("at least as much free disk space as the sum of the 2 input files.\n\n");
   exit (1);
}

void Open_Files(char* szFile1, char* szFile2, char* szFile3){
   char temp[150];
   if ((fpFile1=fopen(szFile1,"rb"))==NULL) {
      printf("\nCannot open file %s for reading.\n\n",szFile1);
      exit (1);
   }
   if ((fpFile2=fopen(szFile2,"rb"))==NULL) {
      printf("\nCannot open file %s for reading.\n\n",szFile2);
      exit (1);
   }
   if ((fpFile3=fopen(szFile3,"wb"))==NULL) {
      printf("\nCannot open file %s for writing.\n\n",szFile3);
      exit (1);
   }
}

int Read_File1(char *szLine_File1){
   if (fgets (szLine_File1, 149, fpFile1)==NULL) {
      if (feof(fpFile1))
         return 1;
      printf("\nError Reading Line of 1st file\n\n");
      exit (1);
   }
   return 0;
}

int Read_File2(char* szLine_File2){
   if (fgets (szLine_File2, 149, fpFile2)==NULL) {
      if (feof(fpFile2))
         return 1;
      printf("\nError Reading Line of 2nd file\n\n");
      exit (1);
   }
   return 0;
}

void Write_Line (char* szData, char* File3) {
   if (!fputs(szData, fpFile3))
      return;
   printf ("Unable to write %s to %s\nAborting.\n\n", szData, File3);
   exit (1);
}

void Remove_Temp_File (char* File1, char* File3){
   if (remove (File1) ==-1) {
      printf ("\nUnable to delete file %s\n", File1);
      printf ("Sorted file is called %s\n\n", File3);
   }
   if (rename (File3, File1)) {
      printf ("\nUnable to rename %s to %s\n", File1, File3);
      printf ("Sorted data is in File %s.\n\n", File3);
   }
   strcpy (File3, File1);
}

int Compare_Lines (char* szLine1, char* szLine2, int bFile1, int bFile2) {
   int i=0,j=0, ii=0, jj=0;
   if (bFile1)
      return 0;
   if (bFile2)
      return 1;
   while (1) {
      while (szLine1[i]=='"' || szLine1[i]==',') {
         i++;
         if ((++ii)==8)
            return 1;
      }
      while (szLine2[j]=='"' || szLine2[j]==',') {
         j++;
         if ((++jj)==8)
            return 0;
      }
      if (szLine1[i]<szLine2[j])
         return 1;
      if (szLine1[i]>szLine2[j])
         return 0;
      i++;
      j++;
   }
}

void display (int *i) {

   char character[4] = "-\\|/";
   if ((*i)%500==0)
      printf ("%c\b",character[*i/500]);
   *i=++(*i)%2000;
}

