title Get and Set interrupt vectors
name intvec

include model.ash
include lattice.ash
include macros.ash
;
;These are NOT C callable.
;

public setvec,getvec

cseg
;
;Set interrupt vector AL to DS:DX.
;
setvec:
	push	es
	push	bx
	mov	bx,0
	mov	es,bx
	mov	bl,al
	mov	bh,0
	shl	bx,1
	shl	bx,1
	pushf
	cli
	mov	es:[bx],dx
	mov	es:[bx + 2],ds
	popf
	pop	bx
	pop	es
	ret
;
;Get interupt vector AL, return in ES:BX.
;
getvec:	push	ds
	push	di
	mov	di,0
	mov	ds,di
	mov	ah,0
	mov	di,ax
	shl	di,1
	shl	di,1
	pushf
	cli
	mov	bx,ds:[di]
	mov	es,ds:[di + 2]
	popf
	pop	di
	pop	ds
	ret

endc

	end
