title Fido Time Routine
name ticker

include model.ash
include lattice.ash

extrn	setvec:near,getvec:near
extrn	tickfunc:near
;
;	"Generic" time tick routines for
;the Fido driver set. This does an INT 14
;to get the timer tick parameters for
;initialization of the clock.
;
;
;set_clk();	Install the time tick
;		functions. After this call
;		the counters should start 
;		incrementing.
;
;clr_clk()	;Reset all the counters.
;
;reset_clk();	Remove the time circuit.
;
dseg
;
;These are the global time variables. They
;get incremented by the timer function.
;
public millisec,millis2,seconds,minutes,hours

millisec dd 0	;milliseconds
millis2 dd 0	;2nd ctr, for modin()
seconds dw 0	;seconds
minutes dw 0
hours dw 0
ticks dw 0	;work counter
endd

cseg
;
;These are the timer tick parameters
;from the driver.
;
intno db (?)	;interrupt number
tickint dw (?)	;how often
ticksec db (?)	;ticks/sec
oldvec dd (?)	;saved orig. vector,
;
;Set clock: Insert our routine in series
;with the PCs INT 08h.
;
func set_clk
	mov	ah,7		;get tick
	int	14h		;function
	mov	cs:tickint,dx	;set INTERVAL
	mov	cs:intno,al	;INT NUMBER
	mov	cs:ticksec,ah	;TICKS/SEC

	mov	al,cs:intno	;vector number,
	call	getvec		;get vector
	mov	word ptr cs:oldvec,bx ;save it,
	mov	word ptr cs:oldvec + 2,es

	mov	al,cs:intno
	mov	dx,cs		;set for ticker
	mov	ds,dx
	mov	dx,offset ticker
	call	setvec
endf set_clk
;
;Clear the clock.
;
func clr_clk
	pushf
	cli
	mov	ticks,0
	mov	word ptr millisec,0
	mov	word ptr millisec + 2,0
	mov	word ptr millis2,0
	mov	word ptr millis2 + 2,0
	mov	seconds,0
	mov	minutes,0
	mov	hours,0
	popf
endf clr_clk
;
;Remove our timer from the circuit.
;
func reset_cl
	mov	al,cs:intno
	mov	dx,word ptr cs:oldvec
	mov	ds,word ptr cs:oldvec + 2
	call	setvec
endf reset_cl
page
;
;This generates two time signals: the seconds
;minutes hours thing, and a millisecond
;timer, which is just a handy thing to have
;around. (And is actually required)
;
ticker:	sti
	push	ds
	push	bx
	push	ax
	mov	ds,cs:dataseg

	mov	ax,cs:tickint	;allocated
	call	tickfunc	;timers
;
;This assumes that the interrupt rate is no 
;faster than 1 millisecond.
;
	mov	ax,cs:tickint
	add	word ptr millisec,ax
	jnc	t1
	inc	word ptr millisec + 2
t1:
	add	word ptr millis2,ax
	jnc	t2
	inc	word ptr millis2 + 2
t2:
;
;Counting seconds, mins, hours is easy.
;
	mov	al,cs:ticksec
	mov	ah,0
	inc	ticks
	cmp	ticks,ax
	jb	t3
	mov	ticks,0
	inc	seconds
	cmp	seconds,60
	jb	t3
	mov	seconds,0
	inc	minutes
	cmp	minutes,60
	jb	t3
	mov	minutes,0
	inc	hours
t3:
;
;Done. Dispatch to the original timer tick,
;that keeps MSDOS time, etc.
;
	pop	ax
	pop	bx
	pop	ds
	jmp	dword ptr cs:[oldvec] ;chain.

endc
	end
