-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class  REAL_REF

inherit
    NUMERIC
        redefine
            infix "+", infix "-", infix "*", infix "/", infix "^",
            prefix "+", prefix "-", valid_divisor, one, zero
    end

    COMPARABLE
        redefine
            infix "<", compare
    end
-----------------------------------------------------------
creation {ANY}
    make
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    item : REAL

-----------------------------------------------------------

    make (value : REAL) is

        do
            item := value
        end
-----------------------------------------------------------

    infix "+" (other : REAL_REF) : REAL_REF is
                        -- Add `other' to Current.
        do
            !!Result.make (item + other.item)
        end
-----------------------------------------------------------

    infix "-" (other : REAL_REF) : REAL_REF is
                        -- Subtract `other' from Current.
        do
            !!Result.make (item - other.item)
        end
-----------------------------------------------------------

    infix "*" (other : REAL_REF) : REAL_REF is
                        -- Multiply `other' by Current.
        do
            !!Result.make (item * other.item)
        end
-----------------------------------------------------------

    infix "/" (other : REAL_REF) : REAL_REF is
                        -- Divide Current by `other'.
        do
            !!Result.make (item / other.item)
        end
-----------------------------------------------------------

    infix "^" (exp : INTEGER) : REAL_REF is
                        -- Raise Current to `exp'-th power.

        do
            !!Result.make (item ^ exp)
        end
-----------------------------------------------------------

    prefix "+" : REAL_REF is

        do
            !!Result.make (item)
        end
-----------------------------------------------------------

    prefix "-" : REAL_REF is

        do
            !!Result.make (-item)
        end
-----------------------------------------------------------

    infix "<" (other : REAL_REF) : BOOLEAN is
                        -- Is Current less than `other'?
        do
            Result := item < other.item
        end
-----------------------------------------------------------

    compare (other : REAL_REF) : INTEGER is
                        -- Compare Current with `other'.
                        -- '<' <==> Result < 0
                        -- '>' <==> Result > 0
                        -- Otherwise Result = 0
        do
            Result := item.compare (other.item)
        end
-----------------------------------------------------------

    valid_divisor (other : REAL_REF) : BOOLEAN is

        do
            Result := (other.item /= 0.0)
        end
-----------------------------------------------------------

    one : REAL_REF is

        do
            !!Result.make (1.0)
        end
-----------------------------------------------------------

    zero : REAL_REF is

        do
            !!Result.make (0.0)
        end
-----------------------------------------------------------

end -- class REAL_REF

