-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   OBJECT_STRUCTURE
                    -- allows you to examine an object's internal
                    -- structure.
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    classname (object : ANY) : STRING is
                    -- The name of the class of which 'object'
                    -- is a direct instance. NOTE: Only the
                    -- base class will be returned.

        external "C" -- changed by x_c_cwc
        alias    "RTC16_classname"
        
        ensure
            not_void     : Result /= Void
            void_is_none : (object = Void) implies (Result.is_equal ("NONE"))
        end
-----------------------------------------------------------
        
    attribute_count (object : ANY) : INTEGER is
                    -- How many attributes does 'object' have?

        external "C" -- changed by x_c_cwc
        alias    "RTC16_attribute_count"

        ensure
            void_has_none : (object = Void) implies (Result = 0)
        end
-----------------------------------------------------------

    attribute_name (object : ANY, i : INTEGER) : STRING is
                    -- Name of 'i'-th attribute of 'object'

        require
            index_in_range : 1 <= i and then i <= attribute_count (object)

        external "C" -- changed by x_c_cwc
        alias    "RTC16_attribute_name"

        ensure
            not_void : Result /= Void
        end
-----------------------------------------------------------

    attribute_type (object : ANY, i : INTEGER) : CHARACTER is
                    -- Type of 'i'-th attribute of 'object'
                    -- Possible values:
                    -- 'b' - for BOOLEAN
                    -- 'c' - for CHARACTER
                    -- 'i' - for INTEGER
                    -- 'p' - for POINTER
                    -- 'r' - for REAL
                    -- 'o' - for OBJECT (everything else)
        require
            index_in_range : 1 <= i and then i <= attribute_count (object)

        external "C" -- changed by x_c_cwc
        alias    "RTC16_attribute_type"
        end
-----------------------------------------------------------

    attribute_offset (object : ANY, i : INTEGER) : INTEGER is
                    -- Offset (in bytes) of 'i'-th attribute of
                    -- 'object' from the beginning of the structure.
        require
            index_in_range : 1 <= i and then i <= attribute_count (object)

        external "C" -- changed by x_c_cwc
        alias    "RTC16_attribute_offset"

        ensure
            non_negative : Result >= 0
        end
-----------------------------------------------------------

    is_expanded (object : ANY, i : INTEGER) : BOOLEAN is
                    -- Is 'i'-th attribute of 'object' expanded?
        require
            index_in_range : 1 <= i and then i <= attribute_count (object)

        external "C" -- changed by x_c_cwc
        alias    "RTC16_is_expanded"
        end
-----------------------------------------------------------

    boolean_value (object : ANY, i : INTEGER) : BOOLEAN is
                    -- Value of 'i'-th attribute of 'object'
                    -- which must be of type BOOLEAN.
        require
            index_in_range : 1 <= i and then i <= attribute_count (object)
            correct_type   : attribute_type (object, i) = 'b'

        external "C" -- changed by x_c_cwc
        alias    "RTC16_boolean_value"
        end
-----------------------------------------------------------

    character_value (object : ANY, i : INTEGER) : CHARACTER is
                    -- Value of 'i'-th attribute of 'object'
                    -- which must be of type CHARACTER.
        require
            index_in_range : 1 <= i and then i <= attribute_count (object)
            correct_type   : attribute_type (object, i) = 'c'

        external "C" -- changed by x_c_cwc
        alias    "RTC16_character_value"
        end
-----------------------------------------------------------

    integer_value (object : ANY, i : INTEGER) : INTEGER is
                    -- Value of 'i'-th attribute of 'object'
                    -- which must be of type INTEGER.
        require
            index_in_range : 1 <= i and then i <= attribute_count (object)
            correct_type   : attribute_type (object, i) = 'i'

        external "C" -- changed by x_c_cwc
        alias    "RTC16_integer_value"
        end
-----------------------------------------------------------

    real_value (object : ANY, i : INTEGER) : REAL is
                    -- Value of 'i'-th attribute of 'object'
                    -- which must be of type REAL.
        require
            index_in_range : 1 <= i and then i <= attribute_count (object)
            correct_type   : attribute_type (object, i) = 'r'

        external "C" -- changed by x_c_cwc
        alias    "RTC16_real_value"
        end
-----------------------------------------------------------

    pointer_value (object : ANY, i : INTEGER) : POINTER is
                    -- Value of 'i'-th attribute of 'object'
                    -- which must be of type POINTER.
        require
            index_in_range : 1 <= i and then i <= attribute_count (object)
            correct_type   : attribute_type (object, i) = 'p'

        external "C" -- changed by x_c_cwc
        alias    "RTC16_pointer_value"
        end
-----------------------------------------------------------

    object_value (object : ANY, i : INTEGER) : ANY is
                    -- Value of 'i'-th attribute of 'object'
                    -- which must be of type ANY.
        require
            index_in_range : 1 <= i and then i <= attribute_count (object)
            correct_type   : attribute_type (object, i) = 'o'

        external "C" -- changed by x_c_cwc
        alias    "RTC16_object_value"
        end
-----------------------------------------------------------

    size (object : ANY) : INTEGER is
                -- Size in bytes of space occupied by 'object'.
                -- NOTE: The dynamic storage occupied by
                --       strings and arrays is not counted here!

        external "C" -- changed by x_c_cwc
        alias    "RTC16_size"
    
        ensure
            zero_count_is_empty : (attribute_count (object) = 0) = (Result = 0)
        end
-----------------------------------------------------------

end -- class OBJECT_STRUCTURE

