-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
expanded class  INTEGER

inherit
    INTEGER_REF
        rename
            make as int_useless
        redefine
            infix "+", infix "-", infix "*", infix "/",
            infix "\\", infix "//", infix "^", infix "<",
            compare, prefix "-", prefix "+", hash_code,
            one, zero
    end
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    infix "+" (other : INTEGER) : INTEGER is
                        -- Add `other' to Current.
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "-" (other : INTEGER) : INTEGER is
                        -- Subtract `other' from Current.
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "*" (other : INTEGER) : INTEGER is
                        -- Multiply `other' by Current.
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "/" (other : INTEGER) : INTEGER is
                        -- Divide Current by `other'.
                        -- Note : Integer division
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "//" (other : INTEGER) : INTEGER is
                        -- Divide Current by `other'.
                        -- Note : Integer division
        do
            Result := Current / other
        end
-----------------------------------------------------------

    infix "\\" (other : INTEGER) : INTEGER is
                        -- Remainder of division of Current by `other'.
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    infix "^" (exp : INTEGER) : INTEGER is
                        -- Raise Current to `exp'-th power.
        external "CWC" -- changed by x_c_cwc
        alias    "RTC6_power"
        end
-----------------------------------------------------------

    infix "<" (other : INTEGER) : BOOLEAN is
                        -- Is Current less than `other'?
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    prefix "+" : INTEGER is

        do
            Result := Current
        end
-----------------------------------------------------------

    prefix "-" : INTEGER is
                        -- Unary minus of Current
        do
            -- This is a dummy
        end
-----------------------------------------------------------

    compare (other : INTEGER) : INTEGER is
                        -- Compare Current with `other'.
                        -- '<' <==> Result < 0
                        -- '>' <==> Result > 0
                        -- Otherwise Result = 0
        do
            Result := Current - other
        end
-----------------------------------------------------------

    hash_code : INTEGER is

        do
            if Current < 0 then
                Result := -Current
            else
                Result := Current
            end
        end
-----------------------------------------------------------

    one : INTEGER is

        do
            Result := 1
        end
-----------------------------------------------------------

    zero : INTEGER is

        do
            Result := 0
        end
-----------------------------------------------------------

end -- class INTEGER

