-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   GENERAL

-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    is_equal (other : like Current) : BOOLEAN is
                        -- Are Current and `other' field-by-field
                        -- identical?
        require
            other_not_void : other /= Void

        do
            if rt_hea then
                Result := rt_is_eequal (other, $rt_cb_is_equal)
            else
                Result := rt_is_equal (other)
            end
        ensure
            same_type : Result implies same_dynamic_type (Current, other)
        end
-----------------------------------------------------------

    frozen standard_is_equal (other : like Current) : BOOLEAN is
                        -- Are Current and `other' field-by-field
                        -- identical?
        require
            other_not_void : other /= Void

        do
            if rt_hea then
                Result := rt_is_eequal (other, $rt_cb_standard_is_equal)
            else
                Result := rt_is_equal (other)
            end
        ensure
            same_type : Result implies same_dynamic_type (Current, other)
        end
-----------------------------------------------------------

    copy (other : like Current) is
                        -- Copy `other' field-by-field onto Current.

        require
            same_type       : same_dynamic_type (Current, other)
            source_not_void : other /= Void

        do
            if rt_hea then
                rt_ecopy (other, $rt_cb_clone)
            else
                rt_copy (other)
            end
        ensure
            copy_is_equal : is_equal (other)
        end
-----------------------------------------------------------

    frozen standard_copy (other : like Current) is
                        -- Copy `other' field-by-field onto Current.

        require
            same_type       : same_dynamic_type (Current, other)
            source_not_void : other /= Void

        do
            if rt_hea then
                rt_ecopy (other, $rt_cb_clone)
            else
                rt_copy (other)
            end
        ensure
            copy_is_equal : is_equal (other)
        end
-----------------------------------------------------------

    frozen equal (some : ANY, other : like some) : BOOLEAN is
                        -- Are `some' and `other' both Void or
                        -- both non-Void and then field-by-field identical?
        do
            Result := (some  = Void and other  = Void) or else
                      (some /= Void and other /= Void) and then
                       some.is_equal (other)
        end
-----------------------------------------------------------

    frozen clone (other : ANY) : like other is
                        -- Create an object with same dynamic type
                        -- as `other' and then copy `other' onto 
                        -- the result.
        do
            if other /= Void then
                Result := rt_clone (other)
                Result.copy (other)
            end

        ensure
            clone_is_equal : equal (Result, other)
        end
-----------------------------------------------------------

    is_deep_equal (other : like Current) : BOOLEAN is
                        -- Recursive ("deep") version of `is_equal'.
        require
            other_not_void : other /= Void

        external "CWC" -- changed by x_c_cwc
        alias    "RTC11_deep_is_equal"

        ensure
            shallow_equal : Result implies is_equal (other)
        end
-----------------------------------------------------------

    frozen deep_equal (some : ANY,other : like some) : BOOLEAN is
                        -- Recursive ("deep") version of `equal'.
        do
            Result := (some  = Void and other  = Void) or else
                      (some /= Void and other /= Void) and then
                       some.is_deep_equal (other)
        end
-----------------------------------------------------------

    deep_copy (other : like Current) is
                        -- Recursive ("deep") version of `copy'.
        require
            same_type       : same_dynamic_type (Current, other)
            source_not_void : other /= Void

        do
            copy (deep_clone (other))

        ensure
            copy_is_deep_equal : is_deep_equal (other)
        end
-----------------------------------------------------------

    deep_clone (other : ANY) : like other is
                        -- Recursive ("deep") version of `clone'.
        do
            if other /= Void then
                Result := rt_deep_clone (other)
            end

        ensure
            clone_is_deep_equal : deep_equal (Result, other)
        end
-----------------------------------------------------------

    frozen same_dynamic_type (some : GENERAL, other : GENERAL) : BOOLEAN is
                        -- Is dynamic type of `some' identical with
                        -- dynamic type of `other'?
        external "C" -- changed by x_c_cwc
        alias    "RTC11_same_dynamic_type"
        end
-----------------------------------------------------------

    frozen conforms_to (other : ANY) : BOOLEAN is
                        -- Is dynamic type of `Current' a
                        -- descendant of dynamic type of `other'?
        external "CWC" -- changed by x_c_cwc
        alias    "RTC11_conforms_to"
        end
-----------------------------------------------------------

    frozen Void : NONE is
                        -- (This is only a dummy declaration)
        once
        end
-----------------------------------------------------------

    frozen null_pointer is
                        -- A null pointer.
        once
        end
-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    rt_clone (obj : ANY) : like obj is

        external "C" -- changed by x_c_cwc
        alias    "RTC11_clone"
        end
-----------------------------------------------------------

    rt_deep_clone (obj : ANY) : like obj is

        external "C" -- changed by x_c_cwc
        alias    "RTC11_deep_clone"
        end
-----------------------------------------------------------

    rt_is_equal (other : ANY) : BOOLEAN is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC11_is_equal"
        end
-----------------------------------------------------------

    rt_is_eequal (other : ANY, fp : POINTER) : BOOLEAN is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC11_is_eequal"
        end
-----------------------------------------------------------

    rt_copy (other : ANY) is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC11_copy"
        end
-----------------------------------------------------------

    rt_ecopy (other : ANY, fp : POINTER) is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC11_ecopy"
        end
-----------------------------------------------------------

    rt_hea : BOOLEAN is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC11_hea"
        end
-----------------------------------------------------------

    rt_cb_is_equal (other : ANY) : BOOLEAN is

        require
            other_not_void : other /= Void

        do
            Result := is_equal (other)
        end
-----------------------------------------------------------

    rt_cb_standard_is_equal (other : ANY) : BOOLEAN is

        require
            other_not_void : other /= Void

        do
            Result := standard_is_equal (other)
        end
-----------------------------------------------------------

    rt_cb_clone : ANY is

        do
            Result := Clone (Current)
        end
-----------------------------------------------------------

end -- class GENERAL

