class   PROBJ
                -- demonstrates use of class OBJECT_STRUCTURE

-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    print (obj : ANY) is

        local
            i, c   : INTEGER
            s      : STRING
            max, j : INTEGER
            a      : ANY
        do
            io.put_string ("Class : ")
            io.put_string (objstr.classname (obj))
            io.put_string ("  size in bytes = ")
            io.put_int (objstr.size (obj))
            io.put_string ("%N---------------------------%N%N")

            from
                i := 1
                c := objstr.attribute_count (obj)
            until
                i > c
            loop
                s := objstr.attribute_name (obj, i)

                if s.count > max then
                    max := s.count
                end
                i := i + 1
            end

            from
                i := 1
            until
                i > c
            loop
                s := objstr.attribute_name (obj, i)

                io.put_string (s)

                from
                    j := s.count
                until
                    j > max
                loop
                    io.put_char (' ')
                    j := j + 1
                end
                io.put_string (" : ")

                inspect objstr.attribute_type (obj, i)
                    when 'b' then
                        io.put_bool (objstr.boolean_value (obj, i))
                    when 'c' then
                        io.put_char (objstr.character_value (obj, i))
                    when 'i' then
                        io.put_int (objstr.integer_value (obj, i))
                    when 'r' then
                        io.put_real (objstr.real_value (obj, i))
                    when 'p' then
                        io.put_string ("(pointer)")
                    when 'o' then
                        a := objstr.object_value (obj, i)
                        s ?= a

                        if s = Void then
                            if a = Void then
                                io.put_string ("Void")
                            else
                                if objstr.is_expanded (obj, i) then
                                    io.put_string ("object of type ")
                                else
                                    io.put_string ("object reference of type ")
                                end
                                io.put_string (objstr.classname (a))
                            end
                        else
                            io.put_string ("%"")
                            io.put_string (s)
                            io.put_string ("%"")
                        end
                    else
                        -- nothing
                end
                io.put_string ("  [")
                io.put_int (objstr.attribute_offset (obj, i))
                io.put_string ("]%N")
                i := i + 1
            end

            if c = 0 then
                io.put_string (" -- No attributes --%N")
            end
            io.put_string ("%N")
        end
-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    io : BASIC_IO is

        once
            !!Result
        end
-----------------------------------------------------------

    objstr : OBJECT_STRUCTURE is

        once
            !!Result
        end
-----------------------------------------------------------

end -- class PROBJ

