indexing

   title:       "The project-wide universal properties: facilities",
                "for being traversable in the both directions";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         traversal, two_way_traversable;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "travrsbl.e"

deferred class TRAVERSABLE

   inherit
      SIMPLE_TRAVERSABLE
         redefine
            cursor
         end

   ---------------------------------------------------------------------------
   feature -- Operations

      cursor: CURSOR is
            -- delivers a new cursor to the beginning of the container
         do
            !!Result.make (Current);
            Result.first
         end

   ---------------------------------------------------------------------------
   feature {CURSOR}

      back (cs: CURSOR) is
            -- moves one item backwards
         require
            proper_cursor: is_inside (cs)

         deferred
         end;

      last (cs: CURSOR) is
            -- positions on the last item
	 require
            proper_cursor: is_inside (cs)

         deferred
         end

end -- deferred class TRAVERSABLE