indexing

   title:       "An example of how TABLE_ITERATOR might be used";
   cluster:     "containers/examples/table_itr [contners/examples/tabl_itr]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "(C) Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    26,Sep,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         table_iterator_demo;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "tir_demo.e"

class TABLE_ITERATOR_DEMO

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make is
            -- ...
         local
            template:   CONTRACT;
            the_table:  SORTED_TABLE [CONTRACT, STRING];
            val_report: REPORT

         do
            !!the_table.make (true);

            !!template.make                                              -- 1
               ("14-95/ABC", "QWERTY Inc.", "14-Dec-96", 10, 17, 9000);
            the_table.put (template, "AB");

            !!template.make                                              -- 2
               ("15-95/QWE", "ALPHA", "26-Jan-96", 21, 19, 11300);
            the_table.put (template, "AZ");

            !!template.make                                              -- 3
               ("33-95/AQC", "QWERTY Inc.", "27-Mar-96", 5, 21, 10000);
            the_table.put (template, "AC");

            !!template.make                                              -- 4
               ("34-95/WEC", "Z-123 GmbH", "28-Mar-96", 100, 31, 10000);
            the_table.put (template, "AA");

            !!template.make                                              -- 5
               ("41-95/YTE", "SUDS AG", "05-Jun-97", 210, 44, 10000);
            the_table.put (template, "WA");

            !!template.make                                              -- 6
               ("42-95/YTE", "ULTER", "01-Dec-99", 10, 52, 30000);
            the_table.put (template, "QA");

            !!template.make                                              -- 7
               ("44-95/OPW", "VPERJED Ltd.", "17-Dec-95", 10, 61, 10500);
            the_table.put (template, "RB");

            !!template.make                                              -- 8
               ("51-95/EER", "Mo & SHe", "07-Nov-96", 30, 71, 9000);
            the_table.put (template, "RA");

            !!template.make                                              -- 9
               ("64-95/TYQ", "Number 1", "31-Aug-97", 10, 83, 20000);
            the_table.put (template, "RC");

            !!template.make                                              -- 10
               ("67-95/PQ", "Twins Plus", "11-Feb-96", 20, 91, 10000);
            the_table.put (template, "IA");

            !!template.make                                              -- 11
               ("68-95/ZXD", "QWERTY Inc.", "21-Apr-97", 40, 101, 10000);
            the_table.put (template, "AX");

            !!template.make                                              -- 12
               ("69-95/RET", "BETA Inc.", "14-Dec-96", 10, 117, 10000);
            the_table.put (template, "ZW");

            --
            -- the following is what you need to prepare the report ...
            --

            !!val_report.make ("All non-Q-contracts, SOV > 9500", 9500, 'Q');
            val_report.attach (the_table);
            val_report.do_if
         end

end -- TABLE_ITERATOR_DEMO