indexing

   title:       "Table iterators: tools for traversing the tables";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         traversal, tool, expert;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "tabl_itr.e"

class TABLE_ITERATOR [G, H]

   inherit
      ITERATOR
         end

   ---------------------------------------------------------------------------
   feature -- Operations

      attach (x: TABLE [G, H]) is
            -- selects the target for traversal
         require
            proper_table: x /= Void
         do
            target := x
         ensure
            well_done: target /= Void
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      extract_list: LIST [G] is
            -- delivers all the elements or items of the table attached the
            -- entries of which including the keys are satisfied the
            -- conditions put by 'test'
         require
            proper_target: target /= Void
         do
            !!Result.make (false);
            from
               cs := target.cursor
            until
               cs.is_finished
            loop
               if test then
                  Result.put (item)
               end;
               cs.forth
            end
         end;

      extract_table: like target is
            -- delivers all the entries of the table attached which are
            -- satisfied the conditions put by 'test'
         require
            proper_target: target /= Void
         do
            !!Result.make (target.unique_keys);
            from
               cs := target.cursor
            until
               cs.is_finished
            loop
               if test then
                  Result.put (item, key)
               end;
               cs.forth
            end
         end;

      target: TABLE [G, H]

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      item: G is
            -- delivers the element or item of the current entry for
            -- "being touched" in features 'action' and 'test' while
            -- traversing the table
         require
            proper_cursor: cs /= Void and then cs.target = target
         do
            Result := target.item_at (cs)
         end;

      key: H is
            -- delivers the key of the current entry for "being touched"
            -- in features 'action' and 'test' while traversing the table
         require
            proper_cursor: cs /= Void and then cs.target = target
         do
            Result := target.key_at (cs)
         end

end -- class TABLE_ITERATOR [G, H]