indexing

   title:       "A class to be used in conjunction with all",
                "the demos available in cluster EXAMPLES";
   cluster:     "containers/examples/supplier [contners/examples/supplier]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "(C) Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    26,Sep,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         sample_for_demo;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "sample.e"

class SAMPLE

   inherit
      ANY
         redefine
            is_equal
         end;

      COMPARABLE
         end;

      HASHABLE
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make (init: STRING) is
            -- the creation procedure
         do
            base := init
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      base: STRING;

      hash_code: INTEGER is
            -- defines hash value to be equal to
            -- the ASCII code of the first character
         local
            hs: USCL_IO
         do
            !!hs; 
            Result := hs.get_hash_code (base.item (1))
         end;

      infix "<" (other: like Current): BOOLEAN is
            -- all the other functions of COMPARABLE are
            -- derived from this one and are effective
            --
         local
            head1, head2 : CHARACTER
         do
            head1 := Current.base.item (1);
            head2 :=   other.base.item (1);
            Result := (head1 < head2)
         end;

      is_equal (other: like Current): BOOLEAN is
            -- are the Current and 'other' first
            -- character of 'base' identical ?
            --
         local
            head1, head2 : CHARACTER
         do
            head1  := Current.base.item (1);
            head2  :=   other.base.item (1);
            Result := (head1 = head2)
         end

end -- class SAMPLE
