indexing

   title:       "Simple I/O facilities for all the demos",
                "available to enjoy in cluster EXAMPLES";
   cluster:     "containers/examples/supplier [contners/examples/supplier]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "(C) Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    26,Sep,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         demo_input_output;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "in_out.e"

class INPUT_OUTPUT

   inherit
      USCL_IO
         end

   ---------------------------------------------------------------------------
   feature -- Operations

      get_a_string (msg: STRING) is
            -- reads a string from the standard input and assigns it to
            -- 'the_string' and then parses, checks it and assigns the
            -- tokens to 'the_character', 'the_first', 'the_second' - if
            -- errors were found outputs some prompts
            --
         local
            done:  BOOLEAN;
            parm1,
            parm2: STRING;
            index,
            tries: INTEGER

         do
            from
               tries := 0
            until
               done
            loop
               io.put_string (msg);
               io.read_line;

               if io.last_string.count > 0 then

                  the_string := io.last_string;
                  the_string.to_lower;

                  index := get_comma_position (the_string);
                  if index >= 0 then

                     the_character := the_string.item (1);

                     the_first  := 0;
                     the_second := 0;

                     if index = 0 then
                        if the_string.count > 1 then
                           the_first := get_integer
                                           (the_string.substring (2,
                                                          the_string.count));
                           done := true
                        else
                           if the_character = '?' then
                              help
                           else
                              done := true
                           end
                        end
                     else
                        the_first := get_integer
                                        (the_string.substring (2, index - 1));
                        the_second := get_integer
                                        (the_string.substring (index + 1,
                                                       the_string.count));
                        done := true
                     end;

                     if the_character /= 'x' and then the_first > 21 then
                        error_the_first;
                        done := false
                     end;

                     if the_second > the_second_upper_bound then
                        error_the_second;
                        done := false
                     end
                  else
                     error_message;
                     tries := 0
                  end
               else
                  -- if nothing were typed ...
                  tries := tries + 1;
                  inspect
                     tries
                  when 1..3, 5..7, 9, 10 then
                     -- nothing
                  when 4 then
                     io.put_string (prompt);
                     io.put_string ("you could type something ...%N")
                  when 8 then
                     help
                  when 11 then
                     the_character := 'q';
                     done := true
                  else
                     tries := 0
                  end
               end
            end
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      the_character: CHARACTER;
      the_first:     INTEGER;
      the_second:    INTEGER;
      the_string:    STRING

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      prompt: STRING is "Demo:  ";

      the_second_upper_bound: INTEGER is
            -- gives the maximum possible value of 'the_second'
         once
         end;

      error_the_first is
            -- prints the error message (concerning 'the_first') ...
         do
            io.put_string (prompt);
            io.put_string ("a sample number must be in range 1 .. 21 only%N")
         end;

      error_the_second is
            -- prints the error message (concerning 'the_second') ...
         do
            io.put_string (prompt);
            io.put_string ("only one number you can put here%N")
         end;

      error_message is
            -- prints the error message in case of unqualified error ...
         do
            io.put_string (prompt);
            io.put_string ("the first symbol typed must be a letter%
                           % following one optional number%N")
         end;

      get_comma_position (src: STRING): INTEGER is
            -- finds a comma position in 'src' and concurrently makes checks
            -- if the first symbol of 'src' is a letter, '?' or '/' and all
            -- the other symbols - if they exist - are digits with an optional
            -- comma between them ...
         local
            index:  INTEGER;
            symbol: CHARACTER;
            found:  BOOLEAN

         do
            from
               index := 1
            until
               index > src.count or else Result < 0
            loop
               symbol := src.item (index);

               inspect
                  index
               when 1 then
                  if symbol < 'a' or else symbol > 'z' then
                     Result := - index
                  else
                     index := index + 1
                  end
               when 2 then
                  if symbol < '0' or else symbol > '9' then
                     Result := - index
                  else
                     index := index + 1
                  end
               else
                  if not found and then symbol = ',' then
                     if index < src.count then
                        Result := index;
                        found  := true;
                        index  := index + 1
                     else
                        Result := - index
                     end
                  elseif symbol >= '0' and then symbol <= '9' then
                     index := index + 1
                  else
                     Result := - index
                  end
               end
            end;

            if src.count = 1 and then (symbol = '?' or else symbol = '/') then
               Result := 0
            end
         end;

      adjust_right (src: STRING): STRING is
            -- moves blanks from the right side of 'src' to the left one
            --
         require
            proper_input: src /= Void and then src.count > 0
         local
            i, j: INTEGER

         do
            from
               i := src.count;
               j := i;
               !!Result.make (i)
            until
               i <= 0
            loop
               if src.item (i) /= ' ' then
                  Result.put (src.item (i), j);
                  j := j - 1
               end;
               i := i - 1
            end
         end;

         print_list (src: LIST [SAMPLE]) is
               -- prints all items of 'src'
            require
               valid_list: src /= Void
            local
               index:   INTEGER;
               int_csr: CURSOR

            do
               from
                  int_csr := src.cursor
               until
                  int_csr.is_finished
               loop
                  if index = 0 then
                     io.put_string ("Demo: ")
                  elseif index \\ 7 = 0 then
                     io.put_string ("%NDemo: ");
                  end;

                  io.put_string (src.item_at (int_csr).base);
                  io.put_string (" ");
                  index := index + 1;
                  int_csr.forth
               end
            end;

      help is
            -- simply prints some help ...
         do
            io.put_string (prompt);   io.put_string
("You can use all the commands put on the right side of your screen.%N");
            io.put_string (prompt);   io.put_string
("Every command starts with a letter ignoring case with the exception of%N");
            io.put_string (prompt);   io.put_string
("Help command which consists only of one symbol '?' and Refresh - '/'.%N");
            io.put_string (prompt);   io.put_string
("%N");
            io.put_string (prompt);   io.put_string
("Besides the letter some commands requires one or two optional numbers%N");
            io.put_string (prompt);   io.put_string
("indicating the corresponding sample(s) which might be used to fill into%N");
            io.put_string (prompt);   io.put_string
("the container. All possible samples put on the left side of the screen.%N");
            io.put_string (prompt);   io.put_string
("%N");
            io.put_string (prompt);   io.put_string
("All the samples are taken equal if their first symbols are equal - for%N");
            io.put_string (prompt);   io.put_string
("example 'Annie' and 'Amy' are identical here - it's done with the only %N");
            io.put_string (prompt);   io.put_string
("target - to enable you to see how duplicates are stored and handled ...%N");
            io.put_string (prompt);   io.put_string
("%N");
            io.put_string (prompt);   io.put_string
("On the right bottom the results of the queries which are executed every%N");
            io.put_string (prompt);   io.put_string
("time after you enter any valid command are shown. Commands 'cursor' and%N");
            io.put_string (prompt);   io.put_string
("'cursor_...' create a cursor if you're running any list ot table demo.%N");
            io.put_string (prompt);   io.put_string
("If it's not 'stop'ed - an arrow'll be pointing to the current item and%N");
            io.put_string (prompt);   io.put_string
("'is_protected = true' will be on. Commands 'back', 'first', 'forth' and%N");
            io.put_string (prompt);   io.put_string
("'last' relates to the cursor created ...%N");
            io.put_string (prompt);   io.put_string
("%N");
            io.put_string (prompt);   io.put_string
("Command 'merge' uses samples with numbers 7, 14, 21 - mind duplicates!%N");
            io.put_string (prompt);   io.put_string
("%N");
            io.put_string (prompt);   io.put_string
("Type / to come back to the main picture ...%N");
         end

end -- class INPUT_OUTPUT
