indexing

   title:       "Stacks: dispensers implementing a last-in, first-out policy";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         stack, LIFO;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "stack.e"

class STACK [G]

   inherit
      DISPENSER [G]
         end

   ---------------------------------------------------------------------------
   feature -- Operations

      put (x: G) is
            -- add the new entry into the dispenser which immediately after
            -- becomes the "active entry" of the dispenser
         do
            if pool = Void then
               !!pool.make (false);
               cs := pool.cursor
            end;

            check cs.is_finished end;

            pool.put (x);
            item := x

         ensure then
            well_done: count = old count + 1
         end;

      remove is
            -- deletes the "active entry" and sets 'item' to the one most
            -- recently put into if at least one entry exists after the
            -- removal - if it does not then 'item' is set to Void
         do
            if not empty then
               pool.remove_last;
               cs.last;
               if empty then
                  item := Void
               else
                  item := pool.item_at (cs);
                  cs.stop
               end
            else
               fault (f_remove, errhlg.sc_is_empty)
            end

         ensure then
            well_done: cs.is_finished and then count = old count - 1
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      list_of_elements: LIST [G] is
            -- delivers all the entries of the dispenser in the order in
            -- which they would be repeatedly removed if it really happened
         do
            !!Result.make (false);
            if not empty then
               check pool /= Void and then count > 0 end;

               from
                  Result.allocate_manually (count);
                  cs.last
               until
                  cs.is_finished
               loop
                  Result.put (pool.item_at (cs));
                  cs.back
               end;

               Result.allocate_automatically
            end

         ensure then
            well_done: cs /= Void implies cs.is_finished
         end

end -- class STACK [G]