indexing

   title:       "Sorted tables: containers which store their two element",
                "entries (element or item itself and the associated key) in",
                "a total relation order (ascending) based on the operations",
                "of class COMPARABLE (the Eiffel Kernel) being done on keys";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         binary_search_tree, two_way_traversable;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "srt_tabl.e"

class SORTED_TABLE [G, H -> COMPARABLE]

   inherit
      TABLE [G, H]
         redefine
            current_keys, find_next, guide, make
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make (is_unique: BOOLEAN) is
            -- tells the container if its entries must be unigue
         local
            init_size: INTEGER

         do
            unique_keys := is_unique;

            init_size := default_size + counterweight;
            check init_size > 0 end;

            !!store.make (1, init_size);

            if unique_keys then
               !SIMPLE_ORDER_WITH_KEYS [H]!guide.make (Current, init_size)
            else
               !ORDER_WITH_KEYS [H]!guide.make (Current, init_size)
            end
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      current_keys: LIST [H] is
            -- delivers all the keys (without duplicates) currently stored in
            -- the table
         local
            pos: INTEGER

         do
            !!Result.make (true);
            pos := guide.first;

            if pos /= 0 then
               from
               invariant
                  pos >= 0 and then pos <= capacity
               until
                  pos = 0
               loop
                  Result.put (guide.get_key (pos));
                  pos := guide.tree_forth (pos)
               end
            end
         end;

      cursor_after (k: H): CURSOR is
            -- delivers a new cursor positioned to the entry the key of which
            -- is closest to and greater than 'k' - the presence of entry with
            -- key 'k' is not essential but if currently there are at all no
            -- such entries in the table then Void is delivered
         require
            proper_key: k /= Void
         local
            pos: INTEGER

         do
            pos := find_first (k);

            if pos /= 0 then
               pos := guide.tree_forth (pos);
               if pos /= 0 then
                  !!Result.make (Current);
                  Result.set_position (pos);
                  Result.activate
               end
            end

         ensure
            well_done: Result /= Void implies is_protected
         end;

      cursor_before (k: H): CURSOR is
            -- delivers a new cursor positioned to the entry the key of which
            -- is closest to and less than 'k' - the presence of entry with
            -- key 'k' is not essential but if currently there are at all no
            -- such entries in the table then Void is delivered
         require
            proper_key: k /= Void
         local
            pos: INTEGER

         do
            pos := find_first (k);
            if pos /= 0 then
               pos := guide.tree_back (pos);
               if pos /= 0 then
                  !!Result.make (Current);
                  Result.set_position (pos);
                  Result.activate
               end
            end

         ensure
            well_done: Result /= Void implies is_protected
         end

   ---------------------------------------------------------------------------
   feature {KEY_PRIORITY_QUEUE} -- Implementation

      item_at_last_key_head: G is
            -- delivers the element or item that has been in the table for the
            -- longest time and associated with the largest key in the table;
            -- if the table is empty then Void is delivered
         do
            if not empty then
               Result := store.item (guide.tree_last)
            end
         end;

      last_key_head: H is
            -- delivers the largest key currently stored in the table;
            -- if the table is empty then Void is delivered
         do
            if not empty then
               Result := guide.get_key (guide.tree_last)
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      find_next (k: H; pos: INTEGER): INTEGER is
            -- finds the first copy of the entry the element or item of which
            -- associated with key 'k' in the table
         do
            Result := guide.forth (pos);

            if Result /= 0 and then
                  not k.is_equal (guide.get_key (Result)) then

               Result := 0
            end
         end;

      guide: SIMPLE_ORDER [H] -- the ordering structure of the container

end -- class SORTED_TABLE [G, H -> COMPARABLE]