indexing

   title:       "An example of how SORTED_LIST might be used";
   cluster:     "containers/examples/srt_list [contners/examples/srt_list]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "(C) Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    26,Sep,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         sorted_list_demo;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "lst_demo.e"

class SORTED_LIST_DEMO

   inherit
      INPUT_OUTPUT
         end;

      USCL_IO
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make is
            -- ...
         local
            found,
            err,
            out: BOOLEAN;
            i  : INTEGER;
            spl: SAMPLE;
            slr: SAMPLE_SUPPLIER;
            csr,
            ptr: CURSOR;
            tmp: SORTED_LIST [SAMPLE]

         do
            !!slr.make;
            source := slr.sample_set_b;

            -- SELECT ONLY ONE PROPER 'make' OF THE FOLLOWING TWO !!!
            -- !!target.make (true);
            !!target.make (false);

            from
               show (csr, position);
               io.put_string ("%NDemo: ...%N");
               get_a_string ("Demo> ")

            until
               the_character = 'q'

            loop
               message := o_k_;
               command := Void;
               err := false;

               inspect

                  the_character

               when 'a' then                                     -- remove_all
                  if the_first > 0 then
                     if target.is_protected then
                        message := list_is_protected
                     else
                        target.remove_all (source.item (the_first))
                     end
                  else
                     err := true
                  end

               when 'b' then                                           -- back
                  if the_first = 0 then
                     if csr /= Void then
                        csr.back;
                        if csr.is_finished then
                           position := 0
                        else
                           position := position - 1
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'c' then                                      -- cursor_at
                  if the_first /= 0 then
                     if csr /= Void and then not csr.is_finished then
                        csr.stop;
                        position := 0
                     end;

                     csr := target.cursor_at (source.item (the_first));

                     if csr = Void then
                        if target.count = 0 then
                           message := list_is_empty
                        else
                           message := no_item
                        end
                     else
                        position := find_position (csr)
                     end
                  end

               when 'd' then                                           -- stop
                  if the_first = 0 then
                     if csr /= Void then
                        if csr.is_finished then
                           message := csr_is_stopped
                        else
                           csr.stop;
                           position := 0
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'e' then                                  -- cursor_before
                  if the_first /= 0 then
                     if csr /= Void and then not csr.is_finished then
                        csr.stop;
                        position := 0
                     end;

                     csr := target.cursor_before (source.item (the_first));

                     if csr = Void then
                        if target.count = 0 then
                           message := list_is_empty
                        else
                           message := no_item
                        end
                     else
                        position := find_position (csr)
                     end
                  end

               when 'f' then                                   -- cursor_after
                  if the_first /= 0 then
                     if csr /= Void and then not csr.is_finished then
                        csr.stop;
                        position := 0
                     end;

                     csr := target.cursor_after (source.item (the_first));

                     if csr = Void then
                        if target.count = 0 then
                           message := list_is_empty
                        else
                           message := no_item
                        end
                     else
                        position := find_position (csr)
                     end
                  end

               when 'h' then                                       -- has_item
                  if the_first > 0 then
                     found := target.has_item (source.item (the_first));
                     command := has_item;
                     if found then
                        message := true_str
                     else
                        message := false_str
                     end
                  else
                     err := true
                  end

               when 'l' then                                           -- last
                  if the_first = 0 then
                     if csr /= Void then
                        csr.last;
                        if csr.is_finished then
                           message := list_is_empty
                        else
                           position := target.count
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'm' then                                          -- merge
                  if the_first = 0 then
                     if not target.is_protected then
                        !!tmp.make (target.unique_items);
                        from
                           i := 7
                        until
                           i > source.count
                        loop
                           tmp.put (source.item (i));
                           i := i + 7
                        end;
                        target.merge (tmp)
                     else
                        message := list_is_protected
                     end
                  else
                     err := true
                  end

               when 'n' then                                          -- forth
                  if the_first = 0 then
                     if csr /= Void then
                        if not csr.is_finished then
                           csr.forth;
                           if csr.is_finished then
                              position := 0
                           else
                              position := position + 1
                           end
                        else
                           message := csr_is_stopped
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'o' then                                       -- count_of
                  if the_first > 0 then
                     command := count_of;
                     message := get_concatenated
                        (1, <<target.count_of (source.item (the_first))>>)
                  else
                     err := true
                  end

               when 'p' then                                            -- put
                  if the_first > 0 then
                     if target.is_protected then
                        message := list_is_protected
                     else
                        target.put (source.item (the_first))
                     end
                  else
                     err := true
                  end

               when 'r' then                                         -- remove
                  if the_first > 0 then
                     if target.is_protected then
                        message := list_is_protected
                     else
                        if target.has_item (source.item (the_first)) then
                           target.remove (source.item (the_first))
                        else
                           message := no_item;
                        end
                     end
                  else
                     err := true
                  end

               when 's' then                                         -- search
                  if the_first > 0 then
                     target.search (source.item (the_first));
                  else
                     err := true
                  end

               when 't' then                                          -- first
                  if the_first = 0 then
                     if csr /= Void then
                        csr.first;
                        if csr.is_finished then
                           message := list_is_empty
                        else
                           position := 1
                        end
                     else
                        message := csr_not_created
                     end
                  else
                     err := true
                  end

               when 'w' then                                       -- wipe_out
                  if the_first = 0 then
                     if target.is_protected then
                        message := list_is_protected
                     else
                        target.wipe_out
                     end
                  else
                     err := true
                  end

               when 'x' then                              -- allocate_manually
                  if the_first > 0 then
                     if target.is_protected then
                        message := list_is_protected
                     else
                        target.allocate_manually (the_first)
                     end
                  else
                     err := true
                  end

               when 'y' then                                         -- cursor
                  if the_first = 0 then
                     if csr /= Void and then not csr.is_finished then
                        csr.stop;
                        position := 0
                     end;
                     csr := target.cursor;
                     if csr.is_finished then
                        message := list_is_empty
                     else
                        position := 1
                     end
                  else
                     err := true
                  end

               when 'z' then
                  if the_first = 0 then
                     target.allocate_automatically
                  else
                     err := true
                  end

               when '/' then
                  -- used only to put the picture on the screen again ...

               else
                  message := unknown_command
               end;

               if err then
                  message := syntax_error
               end;

               if not out then
                  show (csr, position)
               else
                  out := false
               end;

               io.put_string ("%NDemo: ");
               io.put_string (the_string);
               io.put_string (" -> ");

               if command /= Void then
                  io.put_string (command);
                  io.put_string (" = ")
               end;

               io.put_string (message);
               io.put_new_line;

               get_a_string ("Demo> ")
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      o_k_:      STRING is "done";
      true_str:  STRING is "true ";
      false_str: STRING is "false";

      error_str: STRING is "! ERROR !";
      empty_str: STRING is "         ";

      count_of:  STRING is "count_of (...)";
      has_item:  STRING is "has_item (...)";

      csr_is_stopped:    STRING is "cursor is 'stop'ped ...";
      csr_not_created:   STRING is "no cursor created ...";
      no_item:           STRING is "no such item ...";
      list_is_empty:     STRING is "list is empty ...";
      list_is_protected: STRING is "list is protected ...";
      unexpected_error:  STRING is "unexpected error ...";
      unknown_command:   STRING is "unknown command ...";
      syntax_error:      STRING is "syntax error ...";

      command:  STRING;
      message:  STRING;
      position: INTEGER;
      pool:     ARRAY [STRING];
      source:   ARRAY [SAMPLE];
      target:   SORTED_LIST [SAMPLE];

      find_position (dst: CURSOR): INTEGER is
            -- finds a position of the item being pointed to by 'dst'
            -- among all the items put already on the screen
         require
            valid_dst: dst /= Void;
            not_empty: target.count > 0
         local
            src: CURSOR

         do
            from
               Result := 1;
               src    := target.cursor
            until
               src.is_finished
            loop
               if target.item_at (dst).is_equal
                     (target.item_at (src)) then
                  src.stop
               else
                  src.forth;
                  Result := Result + 1
               end
            end;

            if Result > target.count then
               message := unexpected_error;
               Result := 0
            end
         end;

      show (ext_csr: CURSOR; index: INTEGER) is
            -- prints the main picture, if 'ext_csr /= Void'
            -- then more data put on screen ...
         local
            i:        INTEGER;
            tmp, txt: STRING;
            int_csr:  CURSOR

         do
            io.put_string ("---- Samples ---");
            from
               i   := 1;
               int_csr := target.cursor;
               if int_csr = Void or else int_csr.is_finished then
                  io.put_string ("        Your list        ")
               else
                  io.put_string ("    --- List item ---    ")
               end;
               io.put_string ("------------- Commands --------------%N")

            until
               i > source.count

            loop
               tmp := get_concatenated
                         (4, <<i, " - ", source.item (i).base, ' '>>);

               if not int_csr.is_finished then
                  if i = index then
                     tmp := get_united (tmp, "    => ")
                  else
                     tmp := get_united (tmp, "       ")
                  end;
                  tmp := get_concatenated (0, <<tmp,
                            target.item_at (int_csr).base, "        ">>);
                  int_csr.forth
               else
                  tmp := get_united (tmp, "                        ");
               end;

               io.put_string (tmp);

               inspect
                  i
               when 1 then
                  io.put_string ("? = Help,    / = Refresh,   q = Quit")
               when 2 then
                  io.put_string ("b - back,    y - cursor,    t - first")
               when 3 then
                  io.put_string ("n - forth,   l - last,      d - stop")
               when 4 then
                  -- nothing to put here ...
               when 5 then
                  io.put_string ("X below - any number out of Samples:")
               when 6 then
                  -- nothing to put here ...
               when 7 then
                  io.put_string ("oX  -  count_of (x: G): INTEGER")
               when 8 then
                  io.put_string ("fX  -  cursor_after (x: G): ...")
               when 9 then
                  io.put_string ("cX  -  cursor_at (x: G): ...")
               when 10 then
                  io.put_string ("eX  -  cursor_before (x: G): ...")
               when 11 then
                  io.put_string ("hX  -  has_item (x: G): BOOLEAN")
               when 12 then
                  io.put_string ("m   -  merge (...)")
               when 13 then
                  io.put_string ("pX  -  put (x: G)")
               when 14 then
                  io.put_string ("rX  -  remove (x: G)")
               when 15 then
                  io.put_string ("aX  -  remove_all (x: G)")
               when 16 then
                  io.put_string ("sX  -  search (x: G)")
               when 17 then
                  io.put_string ("w   -  wipe_out")
               when 18 then
                  io.put_string ("------------------ SORTED_LIST LIVE:")
               when 19 then
                  io.put_string ("found = ");
                  if target.found then
                     txt := true_str
                  else
                     txt := false_str
                  end;
                  io.put_string (txt);
                  io.put_string (", found_item: ");
                  if target.found then
                     if target.found_item /= Void then
                        io.put_string (target.found_item.base)
                     else
                        io.put_string (error_str)
                     end
                  end

               when 20 then
                  io.put_string ("item_at: ");
                  if ext_csr /= Void and then not ext_csr.is_finished then
                     if target.item_at (ext_csr) /= Void then
                        io.put_string (target.item_at (ext_csr).base)
                     else
                        io.put_string (error_str)
                     end
                  else
                     io.put_string (empty_str)
                  end;
                  io.put_string ("  ,  empty = ");
                  if target.empty then
                     txt := true_str
                  else
                     txt := false_str
                  end;
                  io.put_string (txt)

               when 21 then
                  io.put_string ("unique_items = ");
                  if target.unique_items then
                     txt := true_str
                  else
                     txt := false_str
                  end;
                  txt := get_concatenated
                            (2, <<txt, ",   count = ", target.count>>);
                  io.put_string (txt)
               end;

               io.put_new_line;
               i := i + 1
            end;

            io.put_string ("----------------------------------------");
            io.put_string (" is_protected = ");
            if target.is_protected then
               txt := true_str
            else
               txt := false_str
            end;
            txt := get_concatenated
                      (2, <<txt, ", capacity = ", target.capacity>>);
            io.put_string (txt);

            if not int_csr.is_finished then
               int_csr.stop
            end
         end

end -- class SORTED_LIST_DEMO