indexing

   title:       "Sorted lists: containers which store their one element",
                "entries in a total relation order (ascending) based on the",
                "operations of class COMPARABLE from the Eiffel Kernel";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         binary_search_tree, two_way_traversable;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "srt_list.e"

class SORTED_LIST [G -> COMPARABLE]

   inherit
      LIST [G]
         redefine
            find_first, find_next, guide, make
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make (is_unique: BOOLEAN) is
            -- tells the container if its entries must be unigue
         local
            init_size: INTEGER

         do
            unique_items := is_unique;
            init_size := default_size + counterweight;

            check
               positive_size: init_size > 0
            end;

            !!store.make (1, init_size);

            if unique_items then
               !SIMPLE_ORDER_ON_ITEMS!guide.make (Current, init_size)
            else
               !ORDER_ON_ITEMS!guide.make (Current, init_size)
            end
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      cursor_after (x: G): CURSOR is
            -- delivers a new cursor positioned to the entry closest to and
            -- greater than 'x' - the presence of entry 'x' is not essential
            -- but if currently there are at all no such entries in the list
            -- then Void is delivered
         require
            valid_argument: x /= Void
         local
            pos: INTEGER

         do
            pos := guide.search (x);

            if pos > 0 then
               pos := guide.tree_forth (pos)
            elseif pos < 0 and then x > store.item (- pos) then
               pos := guide.tree_forth (- pos)
            else
               pos := - pos
            end;

            check pos >= 0 end;

            if pos > 0 then
               !!Result.make (Current);
               Result.set_position (pos);
               Result.activate
            end

         ensure
            well_done: Result /= Void implies is_protected
         end;

      cursor_before (x: G): CURSOR is
            -- delivers a new cursor positioned to the entry closest to and
            -- less than 'x' - the presence of entry 'x' is not essential
            -- but if currently there are at all no such entries in the list
            -- then Void is delivered
         require
            valid_argument: x /= Void
         local
            pos: INTEGER

         do
            pos := guide.search (x);

            if pos > 0 then
               pos := guide.tree_back (pos)
            elseif pos < 0 and then x < store.item (- pos) then
               pos := guide.tree_back (- pos)
            else
               pos := - pos
            end;

            check pos >= 0 end;

            if pos > 0 then
               !!Result.make (Current);
               Result.set_position (pos);
               Result.activate
            end

         ensure
            well_done: Result /= Void implies is_protected
         end

   ---------------------------------------------------------------------------
   feature {PRIORITY_QUEUE} -- Implementation

      last_head: G is
            -- delivers the largest entry in the list; if currently it's not
            -- unique (there are duplicates of it) then the one that has been
            -- in the list for the longest time
         do
            if not empty then
               Result := store.item (guide.tree_last)
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      guide: SIMPLE_ORDER [G]; -- the ordering structure of the container

      find_first (x: G): INTEGER is
            -- finds the first copy of the entry in the list
         do
            Result := guide.search (x);
            if Result < 0 then
               Result := 0
            end
         end;

      find_next (x: G, pos: INTEGER): INTEGER is
            -- finds the duplicates of the entry which is stored at 'pos';
            -- traversal is towards the end of the list
         do
            Result := guide.forth (pos);
            if Result /= 0 and then not store.item (Result).is_equal (x) then
               Result := 0
            end
         end

end -- class SORTED_LIST [G -> COMPARABLE]