indexing

   title:       "The project-wide universal properties: facilities for",
                "being traversable in one direction - towards the last entry";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         traversal, one_way_traversable;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "spl_trvs.e"

deferred class SIMPLE_TRAVERSABLE

   ---------------------------------------------------------------------------
   feature -- Operations

      cursor: SIMPLE_CURSOR is
            -- delivers a new cursor to the beginning of the container
         do
            !!Result.make (Current);
            Result.first
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      is_inside (cs: like cursor): BOOLEAN is
            -- is this cursor traversing the container ?
         require
            valid_argument: cs /= Void

         do
            if cs.target /= Void and then cs.target = Current then
               Result := not cs.is_finished
            end
         end;

      is_protected: BOOLEAN is
            -- true if at least one cursor is traversing the container;
            -- otherwise - false
         do
            Result := cs_counter > 0
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CURSOR}

      cs_counter: INTEGER; -- number of the cursors checked in but not yet out

      first (cs: SIMPLE_CURSOR) is
            -- positions on the first item
         require
            proper_cursor: is_inside (cs)

         deferred
         end;

      forth (cs: SIMPLE_CURSOR) is
            -- moves one item forward
         require
            proper_cursor: is_inside (cs)

         deferred
         end;

      check_in is
            -- used to keep trace of active cursors
         do
            cs_counter := cs_counter + 1
         end;

      check_out is
            -- used to keep trace of active cursors
         require
            a_good_match: cs_counter > 0

         do
            cs_counter := cs_counter - 1
         end

end -- deferred class SIMPLE_TRAVERSABLE