indexing

   title:       "The project-wide universal properties:",
                "the class is an ancestor to all the dispensers";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "spl_dpsr.e"

deferred class SIMPLE_DISPENSER [G]

   ---------------------------------------------------------------------------
   feature -- Operations

      remove is
            -- deletes the "active entry" and sets 'item' and possibly 'key'
            -- to another one (algorithms of selecting a new "active entry"
            -- differ in all dispensers) or - Void if there're no more entries
         require
            not_empty: not empty

         deferred
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      empty: BOOLEAN is
            -- is the dispenser empty ?
         deferred
         end;

      item: G -- the "active entry" of the dispenser - in dispensers with two
              -- element entries attribute 'key' will be also considered as a
              -- part of the "active entry"

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      make (is_unigue: BOOLEAN) is
            -- needn't be used for the dispensers ...
         do
         end

   ---------------------------------------------------------------------------
   invariant

      correct_emptiness: (empty implies item = Void)
                         and then (item = Void implies empty);
      proper_tuning:     (not empty implies item /= Void)
                         and then (item /= Void implies not empty)

end -- deferred class SIMPLE_DISPENSER [G]