indexing

   title:       "The project-wide universal properties:",
                "the class is an ancestor to all the container classes";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "spl_ctnr.e"

deferred class SIMPLE_CONTAINER

   ---------------------------------------------------------------------------
   feature -- Operations

      make (is_unigue: BOOLEAN) is
            -- tells the container if its entries must be unigue
         deferred
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      empty: BOOLEAN is
            -- is the container empty ?
         do
            Result := (count = 0)
         end;

      count: INTEGER is
            -- gives the number of entries in the container or equally
            -- the number of the slots used for storing the entries
         deferred
         end;

      capacity: INTEGER is
            -- gives the number of all the slots allocated in the container
            -- (all the containers may have not only slots occupied by the
            -- entries already put into but unused ones also)
         deferred
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_POOL} -- Implementation

      halt (xobject: SIMPLE_POOL; routine_name: STRING) is
            -- stops the execution issuing 'unexpected error' (type SCXX);
            -- happens as a result of existing internal problem (bug) ...
         require
            valid_object: xobject /= Void;
            valid_name:   routine_name /= Void

         do
            errhlg.stop (Current, xobject, routine_name, errhlg.sc_unexpected)
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      errhlg: CONTAINER_ERROR_HANDLER is

         once
            !!Result.make
         end;

      -- the following constants are used to call 'fault' in the descendents

      f_allocate:      STRING is "allocate";
      f_back:          STRING is "back";
      f_extend:        STRING is "extend";
      f_forth:         STRING is "forth";
      f_merge:         STRING is "merge";
      f_put:           STRING is "put";
      f_remove:        STRING is "remove";
      f_remove_all:    STRING is "remove_all";
      f_remove_last:   STRING is "remove_last";
      f_restructure:   STRING is "restructure";
      f_wipe_out:      STRING is "wipe_out";

      fault (routine_name: STRING; error_code: INTEGER) is
            -- stops the execution; usually it is a reply for any incorrect
            -- user's actions which might happen while handling a container
         require
            valid_name:  routine_name /= Void;
            proper_code: error_code >= errhlg.sc_is_empty and then
                         error_code <= errhlg.sc_out_of_range
         do
            errhlg.stop (Current, Void, routine_name, error_code)
         end

   ---------------------------------------------------------------------------
   invariant

      no_miracle: count >= 0 and then count <= capacity

end -- deferred class SIMPLE_CONTAINER