indexing

   title:       "Simple cursors: tools for traversing all the ancestors",
                "of class SIMPLE_TRAVERSABLE (a class of USCL)";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         traversal, tool, expert, one_way_traversable;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "spl_crsr.e"

class SIMPLE_CURSOR

   creation {SIMPLE_TRAVERSABLE}
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      first is
            -- positions on the first item
         do
            activate;
            -- if the structure is empty the cursor will be 'stop'-ed
            target.first (Current)
         end;

      forth is
            -- moves one item forward
         require
            still_inside: not is_finished

         do
            -- if the end is reached the cursor will be 'stop'-ed
            target.forth (Current)
         end;

      stop is
            -- stops traversal
         do
            if not is_finished then
               is_finished := true;
               target.check_out
            end
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      is_finished: BOOLEAN;        --  is the end of the structure reached ?

      target: SIMPLE_TRAVERSABLE   --  the structure the cursor belongs to

   ---------------------------------------------------------------------------
   feature {SIMPLE_TRAVERSABLE} -- Implementation

      position: INTEGER; -- position of the current item if 'not is_finished'

      make (tgt: SIMPLE_TRAVERSABLE) is
            -- ...
         require
            valid_argument: tgt /= Void

         do
            target := tgt;
            is_finished := true
         end;

      set_position (pos: INTEGER) is
            -- keeps the position of the cursor's current item of the structure
         require
            valid_position: pos > 0

         do
            position := pos
         end;

      activate is
            -- makes the cursor is active
         require
            is_attached: target /= Void

         do
            if is_finished then
               is_finished := false;
               target.check_in
            end
         end

end -- class SIMPLE_CURSOR