-- I/O dependent on the compiler being used. This is for Eiffel/S 1.3

class USCL_IO

   ------------------------------------------------------------------------
   feature -- Convertors ...

      get_concatenated (width: INTEGER; src: ARRAY [ANY]): STRING is
            -- unites all the items of 'src' in one string using 'width'
            -- digits for representing any integer in 'src' ...
         require
            valid_source: src /= Void
         local
            a : ANY;
            i : INTEGER;
            pb: BOOLEAN_REF;
            pc: CHARACTER_REF;
            pi: INTEGER_REF;
            ps,
            st: STRING

         do
            if src = Void then
               Result := "void"
            else
               from
                  i := src.lower
               until
                  i > src.upper
               loop
                  a  := src.item (i);
                  st := Void;

                  -- boolean ?
                  pb ?= a;
                  if pb /= Void then
                     if pb.item then
                        st := "true "
                     else
                        st := "false"
                     end
                  else
                     -- character ?
                     pc ?= a;
                     if pc /= Void and then pc.item /= '%U' then
                        !!st.make (1);
                        st.put (pc.item, 1)
                     else
                        -- integer ?
                        pi ?= a;
                        if pi /= Void and then width /= 0 then
                           st := fmt.i2s (fmt.i2s ("", width), pi.item)
                        else
                           -- string ?
                           ps ?= a;
                           if ps /= Void then
                              st := ps
                           end
                        end
                     end
                  end;

                  if i = src.lower or else Result = Void then
                     Result := st
                  elseif st /= Void then
                     Result.append (st)
                  end;
                  i := i + 1

               end -- loop
            end
         end;

      get_fixed (width: INTEGER; src: STRING): STRING is
            -- delivers 'src' exactly in 'width' characters ...
         require
            valid_string: src /= Void;
            real_width:   width > 0
         local
            idx: INTEGER

         do
            !!Result.make (width);
            from
               idx := 1
            until
               idx > width
            loop
               if idx > src.count then
                  Result.put (' ', idx)
               else
                  Result.put (src.item (idx), idx)
               end;
               idx := idx + 1
            end
         end;

      get_hash_code (symbol: CHARACTER): INTEGER is
            -- ...
         do
            Result := symbol.to_integer
         end;

      get_integer (src: STRING): INTEGER is
            -- ...
         require
            valid_string: src /= Void
         do
            Result := fmt.s2i (src)
         end;

      get_united (str_a, str_b: STRING): STRING is
            -- unites two strings ...
         require
            valid_str_a: str_a /= Void;
            valid_str_b: str_b /= Void
         do
            Result := str_a;
            Result.append (str_b)
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      io: STD_FILES is
         once
            !!Result
         end;

      fmt: FORMAT is
         once
            !!Result
         end

end -- class USCL_IO
