-- The Eiffel compiler dependent routines. The following is for Eiffel/S 1.3

class MISCELLANEOUS

   ---------------------------------------------------------------------------
   feature -- Operations

      shutdown (name, msg: STRING; code: INTEGER; xobject: ANY) is
            -- stops the execution by issuing a user defined exception
         require
            valid_name: name /= Void
         local
            index : INTEGER;
            source: STRING

         do
            !!source.adapt (name);
            source.to_lower;

            from
               index := 1
            invariant
               index > 0 and then index <= name.count + 1
            variant
               name.count - index + 1
            until
               index > name.count
            loop
               if source.item (index) = '.' then
                  source := source.substring (index + 1, name.count);
                  index := name.count
               elseif source.item (index) = '(' then
                  index := name.count
               end;
               index := index + 1
            end;

            exc.raise (source, msg, code, xobject)
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      get_class_name (xobject: ANY): STRING is
            -- delivers the name of the class associated with 'object'
         do
            if xobject /= Void then
               !!Result.adapt (obj.classname (xobject))
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      exc: EXCEPTION is
         once
            !!Result
         end;

      obj: OBJECT_STRUCTURE is
         once
            !!Result
         end

end -- class MISCELLANEOUS