indexing

   title:       "An example of how QUEUE might be used";
   cluster:     "containers/examples/queue [contners/examples/queue]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "(C) Frieder Monninger & Alexei Shestialtynov, 1995";
   authors:     "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    26,Sep,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         queue_demo;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "que_demo.e"

class QUEUE_DEMO

   inherit
      INPUT_OUTPUT
         redefine
            help
         end;

      USCL_IO
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make is
            -- procedure ...
         local
            err: BOOLEAN;
            idx: INTEGER;
            spl: SAMPLE;
            slr: SAMPLE_SUPPLIER

         do
            !!slr.make;
            source := slr.sample_set_a;

            !!target;   -- creating a queue ...

            from
               show;
               io.put_string ("%NDemo: ...%N");
               get_a_string ("Demo> ")

            until
               the_character = 'q'

            loop
               message := o_k_;
               err := false;

               inspect
                  the_character

               when 'p' then                                            -- put
                  if the_first > 0 then
                     target.put (source.item (the_first))
                  else
                     err := true
                  end

               when 'r' then                                         -- remove
                  if target.empty then
                     message := queue_is_empty
                  else
                     target.remove
                  end

               when '/' then
                  -- used only to put the picture on the screen again ...

               else
                  message := unknown_command
               end;

               if err then
                  message := syntax_error
               end;

               show; -- printing the main picture with the results ...

               io.put_string ("%NDemo: ");
               io.put_string (the_string);
               io.put_string (" -> ");

               io.put_string (message);
               io.put_new_line;

               get_a_string ("Demo> ")
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      o_k_:      STRING is "done";
      true_str:  STRING is "true ";
      false_str: STRING is "false";

      empty_str: STRING is "         ";

      queue_is_empty:    STRING is "queue is empty ...";
      unknown_command:   STRING is "unknown command ...";
      syntax_error:      STRING is "syntax error ...";

      message: STRING;
      pool:    ARRAY [STRING];
      source:  ARRAY [SAMPLE];
      target:  QUEUE [SAMPLE];

      help is
            -- simply print some help ...
         do
            io.put_string (prompt);   io.put_string
               ("Hmm ... It seems to be nothing to add ...%N");
         end;

      show is
            -- print the main picture ...
         local
            idx: INTEGER;
            tmp,
            txt: STRING;
            csr: CURSOR;
            set: LIST [SAMPLE]

         do
            set := target.list_of_elements;
            io.put_string ("---- Samples ---");
            from
               idx := 1;
               csr := set.cursor;
               if csr.is_finished then
                  io.put_string ("         Your queue         ")
               else
                  io.put_string ("   *** Items in queue ***   ")
               end;
               io.put_string ("------------- Notes -------------%N")

            until
               idx > source.count

            loop
               tmp := get_concatenated (4, <<idx, " - ",
                         source.item (idx).base, "  ">>);

               if idx > 1 then
                  if not csr.is_finished then
                     if idx = 2 then
                        tmp := get_united (tmp, "Head => ")
                     elseif idx /= 2 and then idx = set.count + 1 then
                        tmp := get_united (tmp, "Tail => ")
                     else
                        tmp := get_united (tmp, "        ")
                     end;
                     tmp := get_concatenated (2, <<tmp, set.item_at (csr).base,
                               "         ">>);
                     csr.forth
                  else
                     tmp := get_united (tmp, "                          ")
                  end
               end;

               io.put_string (tmp);

               inspect
                  idx
               when 1 then
                  -- nothing to put here ...
               when 2 then
                  if target.empty then
                     io.put_string (" You can play with Your queue by");
                  else
                     io.put_string (" Head is the only %"active entry%"")
                  end
               when 3 then
                  if target.empty then
                     io.put_string (" using the commands placed below")
                  elseif target.count = 1 then
                     io.put_string ("               of the container")
                  else
                     io.put_string (" Tail is shown only for fun ...")
                  end
               when 4 then
                  -- nothing to put here ...
               when 5 then
                  -- nothing to put here ...
               when 6 then
                  io.put_string ("------------ Commands ------------")
               when 7 then
                  -- nothing to put here ...
               when 8 then
                  io.put_string ("? = Help,   / = Refresh,  q = Quit")
               when 9 then
                  -- nothing to put here ...
               when 10then
                  -- nothing to put here ...
               when 11 then
                  io.put_string ("X below: a number in range 1 .. 21")
               when 12 then
                  io.put_string (" corresponding the sample selected")
               when 13 then
                  -- nothing to put here ...
               when 14 then
                  io.put_string ("pX - put (X: G)")
               when 15 then
                  io.put_string ("r  - remove")
               when 16 then
                  -- nothing to put here ...
               when 17 then
                  -- nothing to put here ...
               when 18 then
                  io.put_string ("----------- QUEUE LIVE -----------")
               when 19 then
                  -- nothing to put here ...
               when 20 then
                  io.put_string ("item: ");
                  if target.item /= Void then
                     io.put_string (target.item.base)
                  else
                     io.put_string (empty_str)
                  end;
                  io.put_string ("     empty = ");
                  if target.empty then
                     txt := true_str
                  else
                     txt := false_str
                  end;
                  io.put_string (txt)
               when 21 then
                  io.put_string ("                    count = ");
                  io.put_string (get_concatenated (2, <<target.count>>))
               end;

               io.put_new_line;
               idx := idx + 1
            end;

            io.put_string ("--------------------------------------------");
            io.put_string ("                 capacity = ");
            io.put_string (get_concatenated (2, <<target.capacity>>));

            if not csr.is_finished then
               csr.stop
            end
         end

end -- class QUEUE_DEMO