indexing

   title:       "Queues: dispensers implementing a first-in, first-out policy";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         queue, FIFO;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "queue.e"

class QUEUE [G]

   inherit
      DISPENSER [G]
         end

   ---------------------------------------------------------------------------
   feature -- Operations

      put (x: G) is
            -- adds the new entry into the dispenser
         do
            if pool = Void then
               !!pool.make (false);
               cs := pool.cursor
            end;

            check cs.is_finished end;

            pool.put (x);

            if item = Void then
               item := x
            end

         ensure then
            well_done: count = old count + 1
         end;

      remove is
            -- deletes the "active entry" and sets 'item' to the one that has
            -- been in the dispenser for the longest time if there are no more
            -- entries after the removal - 'item' is set to Void
         local
            head: G

         do
            if not empty then
               cs.first;
               head := pool.item_at (cs);
               cs.stop;
               pool.remove (head);
               cs.first;
               if empty then
                  item := Void
               else
                  item := pool.item_at (cs);
                  cs.stop
               end
            else
               fault (f_remove, errhlg.sc_is_empty)
            end

         ensure then
            well_done: cs.is_finished and then count = old count - 1
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      list_of_elements: LIST [G] is
            -- delivers all the entries of the dispenser in the order in
            -- which they would be repeatedly removed if it really happened
         do
            !!Result.make (false);
            if not empty then
               check pool /= Void and then count > 0 end;

               from
                  Result.allocate_manually (count);
                  cs.first
               until
                  cs.is_finished
               loop
                  Result.put (pool.item_at (cs));
                  cs.forth
               end;

               Result.allocate_automatically
            end

         ensure then
            well_done: cs /= Void implies cs.is_finished
         end

end -- class QUEUE [G]