indexing

   title:       "Priority queues: dispensers with one element entries",
                "in which only the largest element is accessed";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         priority_queue, the_largest_element;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "pr_queue.e"

class PRIORITY_QUEUE [G -> COMPARABLE]

   inherit
      DISPENSER [G]
         redefine
            pool
         end

   ---------------------------------------------------------------------------
   feature -- Operations

      put (x: G) is
            -- adds the new entry into the dispenser
         do
            if pool = Void then
               !!pool.make (false);
               cs := pool.cursor
            end;

            check cs.is_finished end;

            pool.put (x);
            item := pool.last_head

         ensure then
            well_done: count = old count + 1
         end;

      remove is
            -- deletes the "active entry" and sets 'item' to the largest one
            -- among those still existing in the dispenser after the removal;
            -- if there are no more entries then 'item' is set to Void
         local
            tail: G

         do
            if not empty then
               cs.last;
               tail := pool.item_at (cs);
               cs.stop;
               pool.remove (tail);
               item := pool.last_head
            else
               fault (f_remove, errhlg.sc_is_empty)
            end

         ensure then
            well_done: cs.is_finished and then count = old count - 1
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      list_of_elements: LIST [G] is
            -- delivers all the entries of the dispenser in the order in
            -- which they would be repeatedly removed if it really happened
         local
            local_stack:   STACK [G];
            current_item:  G;
            pop_stack_out,
            push_on_stack: BOOLEAN

         do
            !!Result.make (false);
            if not empty then
               check pool /= Void and then count > 0 end;

               from
                  !!local_stack;
                  Result.allocate_manually (count);
                  cs.last
               until
                  Result.count = count
               loop
                  push_on_stack := true;
                  pop_stack_out := false;

                  if cs.is_finished then
                     pop_stack_out := true;
                     push_on_stack := false
                  else
                     current_item := pool.item_at (cs);
                     cs.back;

                     -- all duplicates are collected on 'local_stack' first
                     if not (local_stack.empty or else
                             current_item.is_equal (local_stack.item)) then

                        pop_stack_out := true
                     end
                  end;

                  if pop_stack_out then
                     check not local_stack.empty end;

                     from
                     until
                        local_stack.empty
                     loop
                        Result.put (local_stack.item);
                        local_stack.remove
                     end
                  end;

                  if push_on_stack then
                     local_stack.put (current_item)
                  end
               end;

               Result.allocate_automatically
            end

         ensure then
            well_done: cs /= Void implies cs.is_finished
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      pool: SORTED_LIST [G] -- the real receptacle for entries to be stored

end -- class PRIORITY_QUEUE [G -> COMPARABLE]