indexing

   title:       "An example how LIST_ITERATOR might be used";
   cluster:     "containers/examples/list_itr [contners/examples/list_itr]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "(C) Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    26,Sep,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         list_iterator_demo;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "lir_demo.e"

class LIST_ITERATOR_DEMO

   inherit
      LIST_ITERATOR [SAMPLE]
         redefine
            action, test
         end;

      USCL_IO
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      action is
            -- ...
         do
            number := number + 1;

            io.put_string
               (get_concatenated (2, <<'%T', item.base, " - No. ", number>>));
            io.put_new_line
         end;

      make is
            -- ...
         local
            index:    INTEGER;
            samples:  ARRAY [SAMPLE];
            the_list: SORTED_LIST [SAMPLE];
            supplier: SAMPLE_SUPPLIER

         do
            !!supplier.make;
            samples := supplier.sample_set_a;
            !!the_list.make (false);

            from index := 1 until index > samples.count loop
               the_list.put (samples.item (index));
               index := index + 1
            end;

            io.put_string ("%NAll items starting with %'F%' ...%N%N");

            -- the following is what you need to go through all the list ...
            attach (the_list);
            do_if
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      test: BOOLEAN is
            -- ...
         do
            if item.base.item (1) = 'F' then
               Result := true
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      number: INTEGER

end -- LIST_ITERATOR_DEMO