indexing

   title:       "List iterators: tools for traversing the lists",
                "(except the lists of class SIMPLE_LIST)";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         traversal, tool, expert;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "list_itr.e"

class LIST_ITERATOR [G]

   inherit
      ITERATOR
         end

   ---------------------------------------------------------------------------
   feature -- Operations

      attach (x: LIST [G]) is
            -- selects the target for traversal
         require
            proper_list: x /= Void
         do
            target := x
         ensure
            well_done: target /= Void
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      extract_list: like target is
            -- delivers all the entries of the list attached which are
            -- satisfied the conditions put by 'test'
         require
            proper_target: target /= Void

         do
            !!Result.make (target.unique_items);
            from
               cs := target.cursor
            until
               cs.is_finished
            loop
               if test then
                  Result.put (item)
               end;
               cs.forth
            end
         end;

      target: LIST [G] -- the structure to be traversed

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      item: G is
            -- delivers the current entry for "being touched" in features
            -- 'action' and 'test' while traversing the list
         require
            proper_cursor: cs /= Void and then cs.target = target
         do
            Result := target.item_at (cs)
         end

end -- class LIST_ITERATOR [G]