indexing

   title:       "Lists: containers with one element entries",
                "implementing a first-in, first-out policy and";
                "supporting traversal in the both directions";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         doubly_linked_list, FIFO, two_way_traversable;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "list.e"

class LIST [G]

   inherit
      SIMPLE_LIST [G]
         undefine
            cursor
         redefine
            item_at, cursor_at, guide, make
         end;

      TRAVERSABLE
         end

   creation
      make

   ---------------------------------------------------------------------------
   feature -- Operations

      make (is_unique: BOOLEAN) is
            -- tells the container if its entries must be unigue
         local
            init_size: INTEGER

         do
            unique_items := is_unique;
            init_size := default_size + counterweight;

            !!store.make (1, init_size);
            !CHAIN!guide.make (Current, init_size)
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      item_at (cs: CURSOR): G is
            -- delivers the entry of the list the cursor is positioned to
         do
            Result := store.item (cs.position)
         end;

      cursor_at (x: G): CURSOR is
            -- delivers a new cursor positioned to the entry; if there is no
            -- such entry currently stored in the list Void is delivered
         local
            pos: INTEGER

         do
            pos := find_first (x);

            if pos /= 0 then
               !!Result.make (Current);
               Result.set_position (pos);
               Result.activate
            end
         end

   ---------------------------------------------------------------------------
   feature {CURSOR}

      last (cs: CURSOR) is
            -- positions on the last item
         do
            if not empty then
               cs.set_position (guide.last)
            else
               cs.stop
            end

         ensure then
            well_done: not empty implies has_item (item_at (cs))
         end;

      back (cs: CURSOR) is
            -- moves one item backwards
         local
            pos: INTEGER

         do
            if not cs.is_finished then
               pos := guide.back (cs.position);
               if pos /= 0 then
                  cs.set_position (pos)
               else
                  cs.stop
               end

            else
               errhlg.stop (Current, cs, "back", errhlg.sc_out_of_range)
            end

         ensure then
            well_done: not cs.is_finished implies has_item (item_at (cs))
         end

   ---------------------------------------------------------------------------
   feature {STACK} -- Implementation

      remove_last is
            -- deletes the last entry of the list
         local
            index: INTEGER

         do
            if is_protected or else empty then
               fault (f_remove_last, errhlg.sc_unexpected)
            else
               index := guide.last;
               guide.remove (index);
               store.put (Void, index);
               count := count - 1;
               shrink (0)
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      guide: CHAIN_CORE -- the ordering structure of the container

end -- class LIST [G]