indexing

   title:       "Facilities for the dispensers with two element entries";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "key_dpsr.e"

deferred class KEYED_DISPENSER [G, H]

   inherit
      KEYED_CONTAINER [G, H]
         export {NONE}
            make
         end;

      SIMPLE_DISPENSER [G]
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      key: H; -- the other part of the "active entry" of the dispenser

      capacity: INTEGER is
            -- gives the number of all the slots allocated in the dispenser
            -- (all the dispensers may have not only slots occupied by the
            -- entries already put into but unused ones also)
         do
            if pool /= Void then
               Result := pool.capacity
            end
         end;

      count: INTEGER is
            -- gives the number of entries in the dispenser or equally
            -- the number of the slots used for storing the entries
         do
            if pool /= Void then
               Result := pool.count
            end
         end;

      table_of_elements: TABLE [G, H] is
            -- delivers all the entries of the dispenser in the order in
            -- which they would be repeatedly removing if it really happened

         deferred
         ensure
            well_done: not empty implies Result /= Void
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      cs:   CURSOR;
      pool: TABLE [G, H] -- the real receptacle for entries to be stored

end -- deferred class KEYED_DISPENSER [G, H]