indexing

   title:       "Some universal common facilites of the guides for classes",
                "HASH_LIST, HASH_TABLE, SORTED_LIST and SORTED_TABLE";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__pool_.e"

deferred class POOL [G]

   inherit
      CHAIN_CORE
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      put_key (x: G; pos: INTEGER) is
            -- adds the new entry into the guide
         require
            valid_key:       x /= Void;
            proper_position: pos > 0 and then pos <= capacity

         deferred
         ensure
            well_done: search (x) > 0
         end;

      remove_key (pos: INTEGER) is
            -- actually deletes the entry from the guide
         require
            proper_position: pos > 0 and then pos <= capacity

         deferred
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Queries

      get_key (pos: INTEGER): G is
            -- delivers the entry stored in the guide at position 'pos'
         require
            proper_position: pos > 0 and then pos <= capacity

         deferred
         end;

      search (x: G): INTEGER is
            -- gives the position (a positive integer) of the entry if it
            -- exists; otherwise - a non-positive integer
         require
            valid_key: x /= Void

         deferred
         ensure
            well_done: Result >= - capacity and then Result <= capacity
         end

end -- deferred class POOL [G]