indexing

   title:       "Specific facilities of the guide for class SORTED_TABLE";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__or_wk.e"

class ORDER_WITH_KEYS [H -> COMPARABLE]

   inherit
      ORDER [H]
         redefine
            remove_internal, resizing
         select
            count, entrance, put, remove, first, last, back, forth
         end;

      WITH_KEYS_FOR_ORDERING [H]
         end

   creation {SIMPLE_CONTAINER}
      make

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      remove_internal (pos: INTEGER) is
            -- brings the duplicate out of the order of the guide
         local
            host, next, prev: INTEGER

         do
            next := right.item (pos);
            prev := left.item (pos);

            if prev > 0 and then next > 0 then
               -- it's neither the head nor the tail of the internal nodes

               entrance := root;
               chain_remove (pos);
               chain_count := chain_count - 1

            else
               -- it's either the head or the tail or both in one ...

               if next <= 0 then
                  -- it's the tail of the internal nodes

                  check
                     non_zero: next /= 0
                  end;

                  out_marker := left.item (- next);
                  host       := get_host (out_marker, - next);

                  check
                     proper_entrance: entrance = pos
                  end

               else
                  -- it's the head of the internal nodes

                  out_marker := prev;
                  host       := get_host (out_marker, pos);

                  check
                     proper_entrance: entrance = - parent.item (host)
                  end;

               end;

               chain_remove (pos);
               chain_count := chain_count - 1;


               if entrance = 0 then
                  -- there is no duplicate copies any longer
                  parent.put (- out_marker, host)
               else
                  -- there are still some of them ...
                  parent.put (- entrance, host)
               end
            end;

            frozen_put_in_stock (pos)
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      resizing (new_size: INTEGER) is
            -- changes the amount of slots allocated
         do
            keys.resize (1, new_size);
            left.resize (1, new_size);
            right.resize (1, new_size);
            color.resize (0, new_size);
            parent.resize (0, new_size)
         end

end -- class ORDER_WITH_KEYS [H -> COMPARABLE]