indexing

   title:       "Some universal common facilities of the guides for classes",
                "SORTED_LIST and SORTED_TABLE (used with duplicates);",
                "---------------------------------------------------------",
                " All algorithms are taken (with minor changes) from book ",
                " Introduction to Algorithms by Thomas H. Cormen, Charles ",
                " E. Leiserson and Ronald L. Rivest (c) The Massachusetts ",
                " Institute of Technology, 1990 --------------------------";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         binary_search_tree, red_black_tree, doubly_linked_list;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__order.e"

deferred class ORDER [G -> COMPARABLE]

   inherit
      CHAIN_CORE
         rename
            next as right, prev as left,
            count as chain_count, first as chain_first, forth as chain_forth,
            put as chain_put, remove as chain_remove
         redefine
            chain_count, put_in_stock
         select
            entrance
         end;

      SIMPLE_ORDER [G]
         redefine
            count, remove, forth, last, back, duplicate,
            get_parent, put_parent, put_in_stock
         select
            count, first, forth, last, back, put, remove
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      duplicate (new, existed: INTEGER) is
            -- puts a duplicate (at position 'pos') of the existing entry (at
            -- position 'existed') in order of the guide
         do
            color.put (black, new);
            parent.put (0, new);

            out_marker := parent.item (existed);

            if out_marker >= 0 then
               -- there are no duplicate copies at the moment ...

               out_marker := - out_marker;
               entrance   := 0

            else
               -- there are already some duplicate copies ...

               entrance   := - out_marker;
               out_marker := left.item (- right.item (entrance))
            end;

            chain_put (new);
            parent.put (- entrance, existed);
            chain_count := chain_count + 1
         end;

      remove (pos: INTEGER) is
            -- brings the entry out of the order of the guide
         local
            next: INTEGER

         do
            if internal_node (pos) then
               -- it's an internal node (a duplicate copy) ...

               remove_internal (pos)

            else
               -- it's a normal node of the tree ...

               if parent.item (pos) < 0 then
                  -- there are some (at least one) internal nodes attached

                  entrance   := - parent.item (pos);
                  next       := - right.item (entrance);
                  out_marker := left.item (next);

                  chain_remove (next);
                  chain_count := chain_count - 1;

                  if entrance = 0 then
                     -- there is no duplicate copies any longer
                     parent.put (- out_marker, pos)
                  else
                     -- there are still some of them ...
                     parent.put (- entrance, pos)
                  end;

                  substitute (pos, next);
                  frozen_put_in_stock (pos);

               else
                  -- there is not any internal node attached

                  check
                     proper_root: parent.item (pos) = 0 implies root = pos
                  end;

                  remove_tree_node (pos)

               end
            end
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Queries

      chain_count: INTEGER; -- number of all duplicates in the guide or equally
                            -- the number of all internal nodes in the tree

      count: INTEGER is
            -- gives the number of used slots or equally the number of entries
            -- stored or kept in the guide
         do
            Result := count_tree_leaves (root) + chain_count
         end;

      forth (pos: INTEGER): INTEGER is
            -- gives the position of the next (about 'pos') entry
         local
            next: INTEGER
         do
            if internal_node (pos) then
               next := right.item (pos);
               if next > 0 then
                  Result := next
               else
                  check
                     not_zero: next /= 0
                  end;
                  Result := tree_forth (get_host (left.item (- next), - next))
               end

            else

               if parent.item (pos) < 0 then
                  Result := - right.item (- parent.item (pos))
               else
                  Result := tree_forth (pos)
               end
            end
         end;

      last: INTEGER is
            -- gives the position of the last entry in the guide
         do
            Result := tree_last;

            if Result > 0 and then parent.item (Result) < 0 then
               Result := - parent.item (Result)
            end
         end;

      back (pos: INTEGER): INTEGER is
            -- gives the position of the previous (about 'pos') entry
         local
            prev: INTEGER

         do
            if internal_node (pos) then
               prev := left.item (pos);

               if prev <= 0 then
                  Result := get_host (prev, pos)
               else
                  Result := prev
               end

            else

               Result := tree_back (pos);

               if Result > 0 and then parent.item (Result) < 0 then
                  Result := - parent.item (Result)
               end
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      out_marker: INTEGER; -- see the ancestors ...

      put_in_stock (pos: INTEGER) is
            -- does nothing at the moment ...
         do
         end;

      remove_internal (pos: INTEGER) is
            -- brings the duplicate out of the order of the guide
         require
            proper_position: pos > 0 and then pos <= capacity;
            valid_target:    internal_node (pos)

         do
            target.halt (Current, "remove")
         end;

      get_host (marker, pos: INTEGER): INTEGER is
            -- finds the position of the first copy of the entry while
            -- having the position of another one
         require
            proper_marker:   marker >= - capacity and marker <= 0;
            proper_position: pos > 0 and then pos <= capacity

         do
            if marker < 0 then

               Result   := left.item (- marker);
               entrance := - parent.item (Result);

               if wrong_entrance (pos) then

                  Result   := right.item (- marker);
                  entrance := - parent.item (Result);

                  if wrong_entrance (pos) then
                     target.halt (Current, "get_host/a")
                  end
               end
            else

               Result   := root;
               entrance := - parent.item (Result);

               if wrong_entrance (pos) then
                  target.halt (Current, "get_host/b")
               end
            end
         end;

      get_parent (pos: INTEGER): INTEGER is
            -- gives the item at position 'index' of array 'parent'
         do
            Result := parent.item (pos);
            if Result < 0 then
               Result := - left.item (- right.item (- Result))
            end
         end;

      put_parent (element, pos: INTEGER) is
            -- puts 'element' at position 'index' into array 'parent'
         do
            if parent.item (pos) < 0 then
               left.put (- element, - right.item (- parent.item (pos)))
            else
               parent.put (element, pos)
            end
         end;

      wrong_entrance (pos: INTEGER): BOOLEAN is
            -- was 'entrance' changed wrongly ?
         require
            proper_position: pos > 0 and then pos <= capacity

         do
            Result := entrance <= 0 or else right.item (entrance) /= - pos
         end

end -- deferred class ORDER [G -> COMPARABLE]