indexing

   title:       "Some universal common facilities of the guides for classes",
                "TABLE, HASH_TABLE and SORTED_TABLE";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__keys_.e"

deferred class WITH_KEYS_FOR_ORDERING [H]

   inherit
      SIMPLE_POOL
         rename
            next as right
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      make (host: SIMPLE_CONTAINER; init_size: INTEGER) is
            -- sets initial values of the guide: 'host' is the structure
            -- the guide belongs to and 'init_size' - the initial amount
            -- of slots to be allocated
         local
            pos: INTEGER

         do
            target := host;
            !!right.make (1, init_size);
            first_free := right.count;

            from
               pos := first_free
            until
               pos = 0
            loop
               right.put (pos - 1, pos);
               pos := pos - 1
            end;

            !!keys.make (1, init_size);
            subsequent_init (init_size)
         end;

      put_key (k: H; pos: INTEGER) is
            -- adds the new entry into the guide
         do
            keys.put (k, pos);
            put (pos)
         end;

      remove_key (pos: INTEGER) is
            -- actually deletes the entry from the guide
         do
            keys.put (Void, pos)
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Queries

      get_key (pos: INTEGER): H is
            -- delivers the entry stored in the guide at position 'pos'
         do
            Result := keys.item (pos)
         end;

      keys: ARRAY [H] -- entries actually stored or kept in the guide

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      subsequent_init (size: INTEGER) is
            -- initializes the internal arrays other than 'next' or 'right';
            -- it's the second outstanding part of any 'make' for table guides
         require
            proper_size: size = capacity

         deferred
         end

end -- deferred class WITH_KEYS_FOR_ORDERING [H]