indexing

   title:       "Specific facilities of the guide for class HASH_TABLE";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__hg_wk.e"

class HASHING_WITH_KEYS [H -> HASHABLE]

   inherit
      HASHING [H]
         rename
            next as right
         select
            first, forth, put, remove
         end;

      WITH_KEYS_FOR_ORDERING [H]
         redefine
            extend
         end

   creation {SIMPLE_CONTAINER}
      make

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      extend (increment: INTEGER) is
            -- ... allocating memory for new slots is forbidden here !!
         once
            target.halt (Current, "extend")
         end;

      subsequent_init (size: INTEGER) is
            -- initializes the internal arrays other than 'next' or 'right';
            -- it's the second outstanding part of creation procedure 'make'
         do
            !!prev.make (1, size);
            !!entry.make (1, size)
         end

end -- class HASHING_WITH_KEYS [H -> HASHABLE]