indexing

   title:       "Specific facilities of the guide for class HASH_LIST";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__hg_oi.e"

class HASHING_ON_ITEMS [G -> HASHABLE]

   inherit
      HASHING [G]
         redefine
            extend, target
         select
            first, forth, put, remove
         end;

      ON_ITEMS_FOR_ORDERING [G]
         end

   creation {SIMPLE_CONTAINER}
      make

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      make (host: HASH_LIST [G]; init_size: INTEGER) is
            -- sets initial values of the guide: 'host' is the structure
            -- the guide belongs to and 'init_size' - the initial amount
            -- of slots to be allocated
         local
            pos: INTEGER

         do
            target := host;
            !!next.make (1, init_size);
            first_free := next.count;

            from
               pos := first_free
            until
               pos = 0
            loop
               next.put (pos - 1, pos);
               pos := pos - 1
            end;

            !!prev.make (1, init_size);
            !!entry.make (1, init_size)
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Queries

      target: HASH_LIST [G] -- the structure the guide belongs to

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      extend (increment: INTEGER) is
            -- ... allocating memory for new slots is forbidden here !!
         once
            target.halt (Current, "extend")
         end

end -- class HASHING_ON_ITEMS [G -> HASHABLE]