indexing

   title:       "Some universal common facilities of the guides for classes",
                "HASH_LIST and HASH_TABLE";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         hash_table, hash_value, collision, chaining, open_addressing;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__hashg.e"

deferred class HASHING [G -> HASHABLE]

   inherit
      CHAIN_CORE
         rename
            first as chain_first, forth as chain_forth,
            put as chain_put, remove as chain_remove
         export {NONE}
            chain_first, chain_forth, chain_put, chain_remove
         end;

      POOL [G]
         redefine
            back, count, first, forth, last, put, remove
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      put (pos: INTEGER) is
            -- puts the new entry in order of the guide
         local
            pos_code: INTEGER

         do
            pos_code := get_key (pos).hash_code \\ capacity + 1;
            entrance := entry.item (pos_code);

            check
               proper_entrance: entrance >= 0 and then entrance <= capacity
            end;

            chain_put (pos);
            entry.put (entrance, pos_code);
            count := count + 1
         end;

      remove (pos: INTEGER) is
            -- brings the entry out of the order of the guide
         local
            pos_code: INTEGER

         do
            pos_code := get_key (pos).hash_code \\ capacity + 1;
            entrance := entry.item (pos_code);

            check
               proper_entrance: entrance >= 0 and then entrance <= capacity
            end;

            chain_remove (pos);
            entry.put (entrance, pos_code);
            count := count - 1
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Queries

      count: INTEGER; -- the number of used slots

      search (x: G): INTEGER is
            -- gives the position of the entry if it exists
         do
            entrance := entry.item (x.hash_code \\ capacity + 1);

            from
               Result := chain_first
            invariant
               proper_step: Result >= 0 and then Result <= capacity
            until
               Result = 0 or else x.is_equal (get_key (Result))
            loop
               Result := chain_forth (Result)
            end
         end;

      first: INTEGER is
            -- gives the position of the first entry
         do
            Result := find_down (1)
         end;

      forth (pos: INTEGER): INTEGER is
            -- gives the position of the next (about 'pos') entry
         do
            Result := next.item (pos);
            if Result < 0 then
               Result := find_down (get_key (pos).hash_code \\ capacity + 2)
            end
         end;

      last: INTEGER is
            -- gives the position of the last entry
         do
            Result := find_up (capacity)
         end;

      back (pos: INTEGER): INTEGER is
            -- gives the position of the previous (about 'pos') entry
         do
            Result := prev.item (pos);
            if Result = 0 then
               Result := find_up (get_key (pos).hash_code \\ capacity)
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      entry: ARRAY [INTEGER]; -- the index of entry points ...

      find_down (slot: INTEGER): INTEGER is
            -- finds the next slot used
         require
            proper_slot: slot > 0 and then slot <= capacity + 1
         local
            pos: INTEGER

         do
            if count /= 0 and then slot <= capacity then

               from
                  pos := slot
               invariant
                  inside_the_range: pos > 0 and then pos <= capacity + 1
               variant
                  proper_step: capacity + 1 - pos
               until
                  pos > capacity or else entry.item (pos) /= 0
               loop
                  pos := pos + 1
               end;

               if pos <= capacity then
                  entrance := entry.item (pos);
                  Result := chain_first
               end
            end

         ensure
            well_done: Result >= 0 and then Result <= capacity
         end;

      find_up (slot: INTEGER): INTEGER is
            -- finds the previous slot used
         require
            proper_slot: slot >= 0 and then slot <= capacity
         local
            pos: INTEGER

         do
            if count /= 0 and then slot > 0 then

               from
                  pos := slot
               invariant
                  pos >= 0 and then pos <= capacity
               variant
                  capacity - (capacity - pos)
               until
                  pos = 0 or else entry.item (pos) /= 0
               loop
                  pos := pos - 1
               end;

               if pos > 0 then
                  Result := entry.item (pos)
               end
            end

         ensure
            well_done: Result >= 0 and then Result <= capacity
         end;

      out_marker: INTEGER is
            -- gives zero once and forever ...
         once
         end;

      resizing (new_size: INTEGER) is
            -- ... changing the amount of slots allocated is forbidden here !!
         once
            target.halt (Current, "resizing")
         end

end -- deferred class HASHING [G -> HASHABLE]