indexing

   title:       "Specific facilities of the guide for class LIST";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         doubly_linked_list;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__chn__.e"

class CHAIN

   inherit
      CHAIN_CORE
         end

   creation {SIMPLE_CONTAINER}
      make

   ---------------------------------------------------------------------------
   feature -- Queries

      make (host: SIMPLE_CONTAINER; init_size: INTEGER) is
            -- sets initial values of the guide: 'host' is the structure
            -- the guide belongs to and 'init_size' - the initial amount
            -- of slots to be allocated
         local
            pos: INTEGER

         do
            target := host;
            !!next.make (1, init_size);
            first_free := next.count;

            from
               pos := first_free
            until
               pos = 0
            loop
               next.put (pos - 1, pos);
               pos := pos - 1
            end;

            !!prev.make (1, init_size)
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Queries

      last: INTEGER is
            -- gives the position of the last entry
         do
            Result := entrance
         end;

      back (pos: INTEGER): INTEGER is
            -- gives the position of the previous (about 'pos') entry
         do
            Result := prev.item (pos);

            if Result < 0 then
               Result := 0
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      out_marker: INTEGER is
            -- gives zero once and forever ...
         once
         end;

      resizing (new_size: INTEGER) is
            -- increases the amount of slots allocated
         do
            next.resize (1, new_size);
            prev.resize (1, new_size)
         end

end -- class CHAIN