indexing

   title:       "Universal facilities of the guide for class LIST";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         doubly_linked_list;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__chn_c.e"

deferred class CHAIN_CORE

   inherit
      SIMPLE_CHAIN_CORE
         redefine
            put, remove
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Operations

      put (pos: INTEGER) is
            -- puts the new entry in order of the guide
         do
            if entrance = 0 then
               next.put (- pos, pos);
               prev.put (out_marker, pos)
            else
               next.put (next.item (entrance), pos);
               next.put (pos, entrance);
               check
                  positive: next.item (entrance) > 0
               end;
               prev.put (entrance, pos)
            end;

            entrance := pos;

            check
               negative: next.item (entrance) < 0
            end
         end;

      remove (pos: INTEGER) is
            -- brings the entry out of the order of the guide
         local
            prev_pos: INTEGER

         do
            prev_pos := prev.item (pos);

            check
               proper_prev:
                  (pos = - next.item (entrance) implies prev_pos <= 0) and then
                  (pos /= - next.item (entrance) implies prev_pos > 0)
            end;

            if prev_pos <= 0 then
               -- the first item is removing ...

               if entrance /= pos then
                  -- there are some other items in the list

                  next.put (- next.item (pos), entrance);
                  prev.put (out_marker, next.item (pos))

               else
                  -- the first item is the only item in the list

                  entrance := 0
               end

            else
               -- not the first item is removing ...

               if entrance = pos then
                  -- the last item is to be removed

                  next.put (next.item (pos), prev_pos);
                  entrance := prev_pos

               else
                  -- not the last item is to be removed

                  next.put (next.item (pos), prev_pos);
                  prev.put (prev_pos, next.item (pos))
               end
            end;

            put_in_stock (pos)
         end

   ---------------------------------------------------------------------------
   feature {SIMPLE_CONTAINER} -- Queries

      back (pos: INTEGER): INTEGER is
            -- gives the position of the previous (about 'pos') entry
         require
            proper_position: pos > 0 and then pos <= capacity;
            not_empty:       last > 0

         deferred
         ensure
            well_done: Result >= 0 and then Result <= capacity
         end;

      last: INTEGER is
            -- gives the position of the last entry
         require
            real_pool: capacity > 0

         deferred
         ensure
            well_done: Result >= 0 and then Result <= capacity
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      prev: ARRAY [INTEGER]; -- references to the previous entries

      out_marker: INTEGER is
            -- gives the non-positive value of the end marker (the reference
            -- to the previous entry of the first entry ...)
         deferred
         end

   ---------------------------------------------------------------------------
   invariant

      non_positive: out_marker <= 0

end -- deferred class CHAIN_CORE