indexing

   title:       "Specific facilities of the guide for class TABLE";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         doubly_linked_list;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "i__cg_wk.e"

class CHAINING_WITH_KEYS [H]

   inherit
      POOL [H]
         rename
            next as right
         end;

      WITH_KEYS_FOR_ORDERING [H]
         end

   creation {SIMPLE_CONTAINER}
      make

   ---------------------------------------------------------------------------
   feature -- Queries

      last: INTEGER is
            -- gives the position of the last entry
         do
            Result := entrance
         end;

      back (pos: INTEGER): INTEGER is
            -- gives the position of the previous (about 'pos') entry
         do
            Result := prev.item (pos);

            if Result < 0 then
               Result := 0
            end
         end;

      search (k: H): INTEGER is
            -- gives the position of the entry
         do
            from
               Result := first
            until
               Result = 0 or else k.is_equal (keys.item (Result))
            loop
               Result := forth (Result)
            end
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      out_marker: INTEGER is
            -- gives zero once and forever ...
         once
         end;

      resizing (new_size: INTEGER) is
            -- changes the amount of slots allocated
         do
            keys.resize (1, new_size);
            prev.resize (1, new_size);
            right.resize (1, new_size)
         end;

      subsequent_init (size: INTEGER) is
            -- initializes the internal arrays other than 'next' or 'right';
            -- it's the second outstanding part of creation procedure 'make'
         do
            !!prev.make (1, size)
         end

end -- class CHAINING_WITH_KEYS [H]