indexing

   title:       "Alternative facilities for traversing the containers";
   cluster:     "containers [contners]";
   project:     "The Universal Simple Container Library (USCL)";
   copyright:   "Frieder Monninger & Alexei Shestialtynov, 1995";
   author:      "Frieder Monninger (fm@eiffel.de)",
                "Alexei Shestialtynov (alexei@eiffel.ru)";
   original:    31,Aug,95;
   version:     1.0;
   last_change:
   approved_by:
   approved:
   key:         traversal;
   done_at:     "SiG Computer (info@eiffel.ru)";
   extrnl_name: "iterator.e"


deferred class ITERATOR

   ---------------------------------------------------------------------------
   feature -- Operations

      action is
            -- you can redefine this procedure to put all the operations
            -- which should be done on every entry of the container being
            -- traversed; the current entry is accessible through queries
            -- 'item' and 'key' - the latter one is only for the tables
            --
         require
            proper_target: target /= Void
         do
            -- do nothing by default ...
         end;

      do_all is
            -- procedure 'action' will be performed on every entry of the
            -- container being traversed unconditionally
         require
            proper_target: target /= Void
         do
            if target /= Void  then
               from
                  cs := target.cursor
               until
                  cs.is_finished
               loop
                  action;
                  cs.forth
               end
            end
         end;

      do_if is
            -- procedure 'action' will be performed on every entry of the
            -- container being traversed if it satisfies query 'test';
            -- "testing" is performing on every entry automatically ...
         require
            proper_target: target /= Void
         do
            if target /= Void  then
               from
                  cs := target.cursor
               until
                  cs.is_finished
               loop
                  if test then
                     action
                  end;
                  cs.forth
               end
            end
         end;

      do_until is
            -- procedure 'action' will be performed on every entry of the
            -- container being traversed - one after another - until query
            -- 'test' gives true; "testing" is performing on every entry
            -- automatically ...
            --
         require
            proper_target: target /= Void
         do
            if target /= Void  then
               from
                  cs := target.cursor
               until
                  test or else cs.is_finished
               loop
                  action;
                  cs.forth
               end
            end
         end;

      do_while is
            -- procedure 'action' will be performed on every entry of the
            -- container being traversed - one after another - while query
            -- 'test' is giving true; "testing" is performing on every entry
            -- automatically ...
            --
         require
            proper_target: target /= Void
         do
            if target /= Void  then
               from
                  cs := target.cursor
               until
                  not test or else cs.is_finished
               loop
                  action;
                  cs.forth
               end
            end
         end

   ---------------------------------------------------------------------------
   feature -- Queries

      target: TRAVERSABLE is
            -- the container is being traversed
         deferred
         end;

      test: BOOLEAN is
            -- you can redefine this query to put the conditions which should
            -- be applied to every entry of the container - one after another;
            -- the current entry is accessible through queries 'item' and
            -- 'key' - the latter one is only for the tables
            --
         require
            proper_target: target /= Void
         do
            Result := true
         end

   ---------------------------------------------------------------------------
   feature {NONE} -- Implementation

      cs: CURSOR

end -- deferred class ITERATOR